/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import net.exogeni.orca.ndl.INdlAbstractDelegationModelListener;
import net.exogeni.orca.ndl.INdlManifestModelListener;
import net.exogeni.orca.ndl.INdlRequestModelListener;
import net.exogeni.orca.ndl.NdlAbstractDelegationParser;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlManifestParser;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.NdlRequestParser;
import net.exogeni.orca.ndl.elements.LabelSet;

public class NdlTDBLeakTest
implements INdlManifestModelListener,
INdlRequestModelListener,
INdlAbstractDelegationModelListener {
    private static String[] manifests = new String[]{"/test-color-extension-manifest.rdf", "/manifest-node-sharedvlan.rdf", "/manifest-node-intra.rdf"};
    private final String RDF_START = "<rdf:RDF>";
    private final String RDF_END = "</rdf:RDF>";

    public void ndlNode(Resource ce, OntModel om, Resource ceClass, List<Resource> interfaces) {
    }

    public void ndlNetworkConnection(Resource l, OntModel om, long bandwidth, long latency, List<Resource> interfaces) {
    }

    public void ndlInterface(Resource l, OntModel om, Resource conn, Resource node, String ip, String mask) {
    }

    public void ndlParseComplete() {
    }

    public void ndlManifest(Resource i, OntModel m) {
    }

    public void ndlLinkConnection(Resource l, OntModel m, List<Resource> interfaces, Resource parent) {
    }

    public void ndlCrossConnect(Resource c, OntModel m, long bw, String label, List<Resource> interfaces, Resource parent) {
    }

    public void ndlNetworkConnectionPath(Resource c, OntModel m, List<List<Resource>> paths, List<Resource> roots) {
        System.out.println("Network Connection Path: " + c);
        if (roots != null) {
            System.out.println("Printing roots");
            for (Resource resource : roots) {
                System.out.println(resource);
            }
        }
        if (paths != null) {
            System.out.println("Printing paths");
            for (List list : paths) {
                StringBuilder sb = new StringBuilder();
                sb.append("   Path: ");
                for (Resource r : list) {
                    sb.append(r + " ");
                }
                System.out.println(sb.toString());
            }
        } else {
            System.out.println("   None");
        }
    }

    public void ndlReservation(Resource i, OntModel m) {
    }

    public void ndlReservationTermDuration(Resource d, OntModel m, int years, int months, int days, int hours, int minutes, int seconds) {
    }

    public void ndlReservationResources(List<Resource> r, OntModel m) {
    }

    public void ndlReservationStart(Literal s, OntModel m, Date start) {
    }

    public void ndlReservationEnd(Literal e, OntModel m, Date end) {
    }

    public void ndlNodeDependencies(Resource ni, OntModel m, Set<Resource> dependencies) {
    }

    public void ndlSlice(Resource sl, OntModel m) {
    }

    public void ndlBroadcastConnection(Resource bl, OntModel om, long bandwidth, List<Resource> interfaces) {
    }

    public void ndlNetworkDomain(Resource dom, OntModel m, List<Resource> netServices, List<Resource> interfaces, List<LabelSet> labelSets, Map<Resource, List<LabelSet>> netLabelSets) {
    }

    private void runM(String reqFile) throws NdlException, FileNotFoundException {
        InputStream is = this.getClass().getResourceAsStream(reqFile);
        if (is == null) {
            is = new FileInputStream(reqFile);
        }
        assert (is != null);
        Scanner s = new Scanner(is);
        String r = s.useDelimiter("\\A").next();
        s.close();
        NdlManifestParser mp = new NdlManifestParser(r, (INdlManifestModelListener)this, NdlModel.ModelType.TdbPersistent, "/tmp/tdb/" + UUID.randomUUID());
        mp.processManifest();
        mp.freeModel();
    }

    private void runA(String reqFile) throws NdlException, FileNotFoundException {
        InputStream is = this.getClass().getResourceAsStream(reqFile);
        if (is == null) {
            is = new FileInputStream(reqFile);
        }
        assert (is != null);
        Scanner s = new Scanner(is);
        String r = s.useDelimiter("\\A").next();
        s.close();
        boolean done = false;
        while (!done) {
            int start = r.indexOf("<rdf:RDF>");
            int end = r.indexOf("</rdf:RDF>");
            if (start == -1 || end == -1) {
                done = true;
                continue;
            }
            String ad = r.substring(start, end + "</rdf:RDF>".length());
            NdlAbstractDelegationParser nadp = new NdlAbstractDelegationParser(ad, (INdlAbstractDelegationModelListener)this, NdlModel.ModelType.TdbPersistent, "/tmp/tdb/" + UUID.randomUUID());
            nadp.processDelegationModel();
            nadp.freeModel();
            r = r.substring(end + "</rdf:RDF>".length());
        }
    }

    private void runR(String reqFile) throws NdlException, FileNotFoundException {
        InputStream is = this.getClass().getResourceAsStream(reqFile);
        if (is == null) {
            is = new FileInputStream(reqFile);
        }
        assert (is != null);
        Scanner s = new Scanner(is);
        String r = s.useDelimiter("\\A").next();
        s.close();
        NdlRequestParser rp = new NdlRequestParser(r, (INdlRequestModelListener)this, NdlModel.ModelType.TdbPersistent, "/tmp/tdb/" + UUID.randomUUID());
        rp.processRequest();
        rp.freeModel();
    }

    public static void main(String[] argv) {
        NdlTDBLeakTest t = new NdlTDBLeakTest();
        ArrayList<Long> meas = new ArrayList<Long>();
        try {
            int i = 0;
            while (true) {
                System.out.println("Iteration " + i + " of " + 100);
                long now = System.currentTimeMillis();
                t.runM(argv[0]);
                t.runA(argv[1]);
                t.runR(argv[2]);
                long later = System.currentTimeMillis();
                meas.add(later - now);
                long heapSize = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                System.out.println("Heap: " + heapSize / 1000000L);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("UNABLE: " + e);
            e.printStackTrace();
            Long avg = 0L;
            int n = 0;
            for (Long v : meas) {
                avg = (avg * (long)n + v) / (long)(n + 1);
            }
            System.out.println("Average:" + avg);
            return;
        }
    }
}

