/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.handlers.nodeagent2;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import net.exogeni.orca.shirako.plugins.config.OrcaAntTask;
import orca.nodeagent2.agentlib.PluginReturn;
import orca.nodeagent2.agentlib.Properties;
import orca.nodeagent2.agentlib.ReservationId;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.tools.ant.BuildException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class RestTask
extends OrcaAntTask {
    protected static final String USERNAME = "admin";
    protected String password;
    protected String na2Url;
    protected URL asUrl;
    protected String prefix;
    protected String returnPrefix;
    protected String plugin;
    protected String reservationId;
    protected String statusProperty;
    protected String errorMsgProperty;
    protected String reservationIdProperty;
    protected RestOperations rop;

    protected int getPort() {
        if (this.asUrl.getPort() == -1) {
            return 80;
        }
        return this.asUrl.getPort();
    }

    protected String getHost() {
        return this.asUrl.getHost();
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setBaseUrl(String u) throws BuildException {
        this.na2Url = u;
        try {
            this.asUrl = new URL(u);
        }
        catch (MalformedURLException ue) {
            throw new BuildException("Invalid NA2 URL " + u);
        }
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }

    public void setReturnPrefix(String rp) {
        this.returnPrefix = rp;
    }

    public void setPlugin(String p) {
        this.plugin = p;
    }

    public void setReservationId(String s) {
        this.reservationId = s;
    }

    public void setStatusProperty(String s) {
        this.statusProperty = s;
    }

    public void setReservationIdProperty(String s) {
        this.reservationIdProperty = s;
    }

    public void setErrorMsgProperty(String s) {
        this.errorMsgProperty = s;
    }

    protected JSONObject collectPluginProperties() {
        JSONObject p = new JSONObject();
        Hashtable props = this.getProject().getProperties();
        if (props == null) {
            return null;
        }
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            if (!key.startsWith(this.prefix)) continue;
            p.put((Object)key, (Object)val);
        }
        return p;
    }

    protected void doPost() throws BuildException {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            client.getCredentialsProvider().setCredentials(new AuthScope(this.getHost(), this.getPort()), (Credentials)new UsernamePasswordCredentials(USERNAME, this.password));
            if (this.rop != RestOperations.JOIN && this.reservationId == null) {
                throw new BuildException("Attribute reservationId must be specified for this operation");
            }
            HttpPost post = new HttpPost(this.na2Url + "/" + this.rop.name().toLowerCase() + "/" + this.plugin + (this.reservationId != null ? "/" + this.reservationId : ""));
            JSONObject p = this.collectPluginProperties();
            StringEntity se = p != null ? new StringEntity(p.toString()) : new StringEntity("");
            se.setContentType("application/json");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            JSONObject o = (JSONObject)JSONValue.parse((String)sb.toString());
            PluginReturn pr = RestTask.convert(o);
            this.getProject().setProperty(this.statusProperty, pr.getStatus() + "");
            this.getProject().setProperty(this.errorMsgProperty, pr.getErrorMsg());
            if (pr.getResId() != null) {
                this.getProject().setProperty(this.reservationIdProperty, pr.getResId().getId());
            } else {
                this.getProject().setProperty(this.reservationIdProperty, "Not available");
            }
            if (pr.getProperties() != null) {
                for (Map.Entry me : pr.getProperties().entrySet()) {
                    this.getProject().setProperty(this.returnPrefix + "." + (String)me.getKey(), (String)me.getValue());
                }
            }
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Unable to POST " + (Object)((Object)this.rop) + " to " + this.plugin + ": " + e);
        }
    }

    private static PluginReturn convert(JSONObject o) throws BuildException {
        long status = (Long)o.get((Object)"status");
        int st = (int)status;
        try {
            String msg;
            JSONObject ridEnvelope = (JSONObject)o.get((Object)"resId");
            ReservationId rid = null;
            if (ridEnvelope != null) {
                rid = new ReservationId((String)ridEnvelope.get((Object)"id"));
            }
            Properties props = null;
            if (o.get((Object)"properties") != null) {
                props = new Properties();
                props.putAll((Map)((JSONObject)o.get((Object)"properties")));
            }
            if ((msg = (String)o.get((Object)"errorMsg")) == null) {
                msg = (String)o.get((Object)"message");
            }
            PluginReturn pr = new PluginReturn(st, msg, rid, props);
            return pr;
        }
        catch (Exception e) {
            throw new BuildException("Unable to convert plugin status " + o);
        }
    }

    public abstract void execute() throws BuildException;

    protected void _execute() throws BuildException {
        if (this.plugin == null || this.password == null || this.na2Url == null || this.prefix == null || this.returnPrefix == null) {
            throw new BuildException("The following input attributes must be specified for the task: plugin, password, baseUrl, prefix and returnPrefix");
        }
        if (this.statusProperty == null || this.reservationIdProperty == null || this.errorMsgProperty == null) {
            throw new BuildException("The following attributes denoting expected property names must be specified in order to produce output: statusProperty, reservationIdProperty, errorMsgProperty");
        }
        this.doPost();
    }

    protected static enum RestOperations {
        JOIN,
        LEAVE,
        MODIFY;

    }
}

