/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.handlers.network.oscars.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import net.exogeni.orca.shirako.plugins.config.OrcaAntTask;
import org.apache.tools.ant.BuildException;

public class UrnRemapperTask
extends OrcaAntTask {
    String oldUrn;
    String newUrnProp;
    String mapFile;
    String mapProp;

    public void setOldUrn(String fu) {
        this.oldUrn = fu;
    }

    public void setNewUrnProp(String tu) {
        this.newUrnProp = tu;
    }

    public void setMapFile(String mf) {
        this.mapFile = mf;
    }

    public void setMapProperty(String mp) {
        this.mapProp = mp;
    }

    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.mapFile == null) {
                throw new BuildException("No URN mapping file specified");
            }
            File props = new File(this.mapFile);
            FileInputStream is = new FileInputStream(props);
            BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            Properties prop = new Properties();
            prop.load(bin);
            bin.close();
            if (this.mapProp == null) {
                throw new BuildException("No map property name specified");
            }
            String map = prop.getProperty(this.mapProp);
            if (map == null || map.length() == 0) {
                System.out.println("No " + this.mapProp + " was found in " + this.mapFile + ", noremapping will be done");
                this.getProject().setProperty(this.newUrnProp, this.oldUrn.trim());
                return;
            }
            String[] maps = map.trim().split(",");
            if (maps.length % 2 != 0) {
                throw new BuildException("Map property contains odd number of entries");
            }
            HashMap<String, String> realMap = new HashMap<String, String>();
            int i = 0;
            while (i < maps.length) {
                realMap.put(maps[i++], maps[i++]);
            }
            if (realMap.containsKey(this.oldUrn.trim())) {
                this.getProject().setProperty(this.newUrnProp, (String)realMap.get(this.oldUrn.trim()));
            } else {
                this.getProject().setProperty(this.newUrnProp, this.oldUrn.trim());
            }
        }
        catch (BuildException e) {
            System.out.println("BuildException in mapping urn: " + (Object)((Object)e));
            throw e;
        }
        catch (Exception e) {
            System.out.println("Exception in mapping urn: " + e);
            throw new BuildException("An error occurred mapping urn: " + e.getMessage(), (Throwable)e);
        }
    }
}

