/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.exogeni.orca.drivers.DriverExitCodes;
import org.apache.log4j.Logger;

public class NumericIDGenerator {
    protected int idCount = 1;
    protected static Properties idMap;
    protected String path;
    protected Logger logger;

    public NumericIDGenerator(String path, Logger logger) {
        if (path == null || logger == null) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.logger = logger;
        idMap = new Properties();
    }

    public void initialize() throws Exception {
        this.readMapFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateIdentifier(String key) {
        int code = 0;
        if (key == null) {
            code = DriverExitCodes.InvalidArguments;
        } else {
            Properties properties = idMap;
            synchronized (properties) {
                String idString = idMap.getProperty(key);
                if (idString == null) {
                    ++this.idCount;
                    idMap.put(key, Integer.toString(this.idCount));
                }
                try {
                    this.writeMapToDisk();
                }
                catch (Exception e) {
                    this.logger.error((Object)"generateIdentifier", (Throwable)e);
                    code = DriverExitCodes.InternalError;
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseIdentifier(String key) {
        int code = 0;
        if (key == null) {
            code = DriverExitCodes.InvalidArguments;
        } else {
            Properties properties = idMap;
            synchronized (properties) {
                idMap.remove(key);
                try {
                    this.writeMapToDisk();
                }
                catch (Exception e) {
                    this.logger.error((Object)"releaseIdentifier", (Throwable)e);
                    code = DriverExitCodes.InternalError;
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIdentifier(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Integer result = null;
        Properties properties = idMap;
        synchronized (properties) {
            String temp = idMap.getProperty(key);
            if (temp != null) {
                try {
                    result = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    this.logger.error((Object)"getIdentifier", (Throwable)e);
                    result = null;
                }
            }
        }
        return result;
    }

    private void writeMapToDisk() throws Exception {
        if (idMap != null && idMap.size() > 0) {
            FileOutputStream stream = new FileOutputStream(this.path);
            idMap.store(stream, null);
            stream.close();
        }
    }

    private void readMapFromDisk() throws Exception {
        File temp = new File(this.path);
        if (temp.exists()) {
            FileInputStream stream = new FileInputStream(temp);
            idMap.load(stream);
            stream.close();
        }
        for (Object s : idMap.values()) {
            Integer i = Integer.parseInt((String)s);
            if (i <= this.idCount) continue;
            this.idCount = i;
        }
    }
}

