/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers.util;

import net.exogeni.orca.drivers.util.DriverScriptExecutionResult;
import org.apache.log4j.Logger;

public class EventLogger {
    protected String event;
    protected String operand;
    protected static final String none = "None";
    protected Logger logger;

    public EventLogger(String event, String operand) {
        this.event = event;
        this.operand = operand;
        this.logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    }

    public void logEvent(String name, Long startTime, Long stopTime) {
        String format = this.event + "<>" + this.operand + "<>" + name + "<>" + startTime + "<>" + stopTime + "<>" + (stopTime - startTime);
        this.logger.info((Object)format);
    }

    public void logEvent(String name, Long startTime) {
        Long stopTime = System.currentTimeMillis();
        String format = this.event + "<>" + this.operand + "<>" + name + "<>" + startTime + "<>" + stopTime + "<>" + (stopTime - startTime);
        this.logger.info((Object)format);
    }

    public void logEvent(DriverScriptExecutionResult r) {
        String formatStdOut = r.stdout != null && r.stdout.length() != 0 ? r.stdout.replace("\n", " ") : none;
        String formatStdErr = r.stderr != null && r.stderr.length() != 0 ? r.stderr.replace("\n", " ") : none;
        String formatCommand = r.command != null && r.command.length() != 0 ? r.command.replace("\n", " ") : none;
        String format = this.event + "<>" + this.operand + "<>" + formatCommand + "<>" + formatStdOut + "<>" + formatStdErr + "<>" + r.code + "<>" + r.startTime + "<>" + r.stopTime;
        this.logger.info((Object)format);
    }
}

