/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.exogeni.orca.drivers.util.DriverScriptExecutionResult;
import org.apache.log4j.Logger;

public class DriverScriptExecutor {
    protected String command;
    protected String[] cmdArray;
    protected boolean log = false;
    protected long timeout = 0L;
    protected Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());

    public DriverScriptExecutor(String[] cmdArray) {
        this.cmdArray = cmdArray;
    }

    public DriverScriptExecutor(String command) {
        this.command = command;
    }

    public DriverScriptExecutor(String[] cmdArray, long timeout, boolean log) {
        this.cmdArray = cmdArray;
        this.timeout = timeout;
        this.log = log;
    }

    public DriverScriptExecutor(String command, long timeout) {
        this.command = command;
        this.timeout = timeout;
    }

    public DriverScriptExecutionResult execute() throws Exception {
        String executedCommand;
        Runtime rt = Runtime.getRuntime();
        if (this.command != null) {
            if (this.log && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Command: " + this.command));
            }
            executedCommand = this.command;
        } else {
            StringBuilder sb = new StringBuilder();
            StringBuilder commandString = new StringBuilder();
            sb.append("Command: ");
            sb.append(this.cmdArray[0]);
            commandString.append(this.cmdArray[0] + " ");
            sb.append("\n Arguments: ");
            for (int i = 1; i < this.cmdArray.length; ++i) {
                sb.append(this.cmdArray[i]);
                commandString.append(this.cmdArray[i]);
                sb.append(" ");
                commandString.append(" ");
            }
            if (this.log && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)sb.toString());
            }
            executedCommand = commandString.toString();
        }
        Process proc = null;
        Long start = System.currentTimeMillis();
        proc = this.cmdArray == null ? rt.exec(this.command) : rt.exec(this.cmdArray);
        InputStream in = proc.getInputStream();
        InputStreamReader inr = new InputStreamReader(in);
        BufferedReader inbr = new BufferedReader(inr);
        InputStream err = proc.getErrorStream();
        InputStreamReader errr = new InputStreamReader(err);
        BufferedReader errbr = new BufferedReader(errr);
        boolean moreIn = true;
        boolean moreErr = true;
        StringBuffer inb = new StringBuffer();
        StringBuffer eb = new StringBuffer();
        while (moreIn || moreErr) {
            String line;
            if (moreIn) {
                line = inbr.readLine();
                if (line == null) {
                    moreIn = false;
                } else {
                    if (inb.length() > 0) {
                        inb.append("\n");
                    }
                    inb.append(line);
                }
            }
            if (!moreErr) continue;
            line = errbr.readLine();
            if (line == null) {
                moreErr = false;
                continue;
            }
            if (eb.length() > 0) {
                eb.append("\n");
            }
            eb.append(line);
        }
        int code = 0;
        code = this.timeout == 0L ? proc.waitFor() : proc.waitFor();
        Long end = System.currentTimeMillis();
        inbr.close();
        errbr.close();
        DriverScriptExecutionResult r = new DriverScriptExecutionResult();
        r.code = code;
        r.command = executedCommand;
        r.stdout = inb.toString();
        r.stderr = eb.toString();
        r.startTime = start;
        r.stopTime = end;
        if (this.log && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exit code: " + r.code));
            this.logger.debug((Object)("Stdout: " + r.stdout));
            this.logger.debug((Object)("Stderr: " + r.stderr));
            this.logger.debug((Object)("ScriptName#" + executedCommand + "#Time#" + (end - start)));
        }
        return r;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setLog(boolean log) {
        this.log = log;
    }
}

