/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.exogeni.orca.drivers.DriverEntry;
import net.exogeni.orca.drivers.DriverFactory;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.beans.Driver;
import net.exogeni.orca.drivers.beans.Drivers;
import net.exogeni.orca.drivers.beans.ObjectFactory;
import org.apache.log4j.Logger;

class FactorySerializer {
    static Logger logger = Logger.getLogger((String)FactorySerializer.class.getCanonicalName());

    FactorySerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int save(DriverFactory factory, String file) {
        int result = 0;
        try {
            ObjectFactory f = new ObjectFactory();
            Drivers d = f.createDrivers();
            Hashtable<DriverId, DriverEntry> hashtable = factory.drivers;
            synchronized (hashtable) {
                for (DriverEntry entry : factory.drivers.values()) {
                    Driver driver = f.createDriver();
                    driver.setId(entry.getDriverId().toString());
                    driver.setClassName(entry.getClassName());
                    driver.setPath(entry.getUrl());
                    d.getDriver().add(driver);
                }
            }
            result = FactorySerializer.save(d, file, factory.getClass().getClassLoader());
        }
        catch (Exception e) {
            logger.error((Object)"save", (Throwable)e);
            result = -1;
        }
        return result;
    }

    public static int load(DriverFactory factory, String file) {
        int result = 0;
        try {
            Drivers d = FactorySerializer.load(file, factory.getClass().getClassLoader());
            if (d == null) {
                result = -1;
            } else {
                List<Driver> l = d.getDriver();
                if (l != null) {
                    for (Driver driver : l) {
                        int code = factory.install(new DriverId(driver.getId()), driver.getClassName());
                        if (code == 0) continue;
                        result = code;
                    }
                }
            }
        }
        catch (Exception e) {
            result = -1;
            logger.error((Object)"load", (Throwable)e);
        }
        return result;
    }

    protected static Drivers load(String file, ClassLoader loader) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"net.exogeni.orca.drivers.beans", (ClassLoader)loader);
            Unmarshaller um = context.createUnmarshaller();
            FileInputStream is = new FileInputStream(file);
            return (Drivers)um.unmarshal((InputStream)is);
        }
        catch (Exception e) {
            logger.error((Object)"loadfile", (Throwable)e);
            return null;
        }
    }

    protected static int save(Drivers drivers, String file, ClassLoader loader) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"net.exogeni.orca.drivers.beans", (ClassLoader)loader);
            Marshaller m = context.createMarshaller();
            FileOutputStream os = new FileOutputStream(file);
            m.marshal((Object)drivers, (OutputStream)os);
            return 0;
        }
        catch (Exception e) {
            logger.error((Object)"savefile", (Throwable)e);
            return -1;
        }
    }
}

