/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers;

import com.mysql.jdbc.StringUtils;
import java.util.Hashtable;
import net.exogeni.orca.drivers.DriverEntry;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.FactorySerializer;
import net.exogeni.orca.drivers.IDriver;
import org.apache.log4j.Logger;

public class DriverFactory {
    public static int CodeInvalidArguments = -1001;
    public static int CodeCannotResolveDriverClass = -1002;
    public static int CodeDriverIsAlreadyInstalled = -1003;
    public static int CodeErrorCleaningUp = -1004;
    public static int CodeDriverIsNotInstalled = -1005;
    public static int CodeCannotCreateDirectory = -1006;
    public static int CodeCannotExpandPackage = -1007;
    public static final String LibFolderName = "lib";
    public static final String PropertyDriverId = "driver.id";
    public static final String ProeprtyActionId = "driver.action.id";
    protected Hashtable<DriverId, DriverEntry> drivers = new Hashtable();
    protected String driversRoot = ".";
    protected Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());

    public Logger getLogger() {
        return this.logger;
    }

    public void setDriversRoot(String driversRoot) {
        this.driversRoot = driversRoot;
    }

    public String getDriversRoot() {
        return this.driversRoot;
    }

    public String getDriverRoot(IDriver driver) {
        return this.getDriverRoot(driver.getId());
    }

    public String getDriverRoot(DriverId id) {
        return this.driversRoot + "/" + id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int install(DriverId id, String className) {
        int result = 0;
        if (id == null || StringUtils.isNullOrEmpty((String)className)) {
            this.logger.warn((Object)"Invalid arguments to install driver");
            return CodeInvalidArguments;
        }
        this.logger.debug((Object)("Trying to install driver. Id=" + id + " class name = " + className));
        String path = this.getDriverRoot(id) + "/" + LibFolderName;
        DriverEntry entry = new DriverEntry(id, path, className);
        if (!entry.isResolvable()) {
            this.logger.warn((Object)"Cannot resolve driver class");
            return CodeCannotResolveDriverClass;
        }
        Hashtable<DriverId, DriverEntry> hashtable = this.drivers;
        synchronized (hashtable) {
            if (this.drivers.containsKey(id)) {
                this.logger.warn((Object)"This driver is already installed");
                result = CodeDriverIsAlreadyInstalled;
            } else {
                this.drivers.put(id, entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upgrade(DriverId id, String className) {
        int result = 0;
        if (id == null || StringUtils.isNullOrEmpty((String)className)) {
            return CodeInvalidArguments;
        }
        String path = this.getDriverRoot(id) + "/" + LibFolderName;
        DriverEntry entry = new DriverEntry(id, path, className);
        if (!entry.isResolvable()) {
            return CodeCannotResolveDriverClass;
        }
        Hashtable<DriverId, DriverEntry> hashtable = this.drivers;
        synchronized (hashtable) {
            if (!this.drivers.containsKey(id)) {
                result = CodeDriverIsNotInstalled;
            } else {
                this.drivers.put(id, entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uninstall(DriverId id) {
        int result = 0;
        if (id == null) {
            return CodeInvalidArguments;
        }
        DriverEntry entry = null;
        Object object = this.drivers;
        synchronized (object) {
            entry = this.drivers.remove(id);
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                if (entry.refCounter == 0 && entry.driver != null) {
                    try {
                        entry.driver.cleanup();
                    }
                    catch (Exception e) {
                        result = CodeErrorCleaningUp;
                    }
                }
            }
        }
        result = CodeDriverIsNotInstalled;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDriver getDriver(DriverId id) {
        DriverEntry entry = this.getDriverEntry(id);
        IDriver result = null;
        if (entry != null && (result = entry.getDriver(this)) != null && result.isStateful()) {
            DriverEntry driverEntry = entry;
            synchronized (driverEntry) {
                ++entry.refCounter;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseDriver(IDriver driver) {
        int result = 0;
        if (driver == null) {
            result = CodeInvalidArguments;
        } else if (driver.isStateful()) {
            DriverEntry entry = this.getDriverEntry(driver.getId());
            if (entry != null) {
                DriverEntry driverEntry = entry;
                synchronized (driverEntry) {
                    --entry.refCounter;
                }
            }
            try {
                driver.cleanup();
            }
            catch (Exception e) {
                result = CodeErrorCleaningUp;
            }
        }
        return result;
    }

    public int load(String file) {
        return FactorySerializer.load(this, file);
    }

    public int save(String file) {
        return FactorySerializer.save(this, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DriverEntry getDriverEntry(DriverId id) {
        if (id == null) {
            return null;
        }
        Hashtable<DriverId, DriverEntry> hashtable = this.drivers;
        synchronized (hashtable) {
            return this.drivers.get(id);
        }
    }
}

