/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import net.exogeni.orca.drivers.DriverFactory;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.IDriver;
import org.apache.log4j.Logger;

class DriverEntry {
    protected DriverId id;
    protected String url;
    protected String className;
    protected Class driverClass;
    protected ClassLoader loader;
    protected IDriver driver;
    protected int refCounter = 0;
    protected Logger logger;

    public DriverEntry(DriverId id, String url, String className) {
        this.id = id;
        this.url = url;
        this.className = className;
        this.logger = Logger.getLogger((String)id.toString());
        this.resolve();
    }

    public boolean isResolvable() {
        return this.driverClass != null;
    }

    public DriverId getDriverId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getClassName() {
        return this.className;
    }

    public synchronized IDriver getDriver(DriverFactory factory) {
        IDriver result = null;
        try {
            if (this.driver == null) {
                if (this.driverClass != null) {
                    result = (IDriver)this.driverClass.newInstance();
                    result.setFactory(factory);
                    int code = result.initialize();
                    if (code != 0) {
                        result = null;
                        this.logger.error((Object)("Driver " + this.id + " failed to initialize. Code: " + code));
                    }
                    if (result.isStateful()) {
                        this.driver = result;
                    }
                }
            } else {
                result = this.driver;
            }
        }
        catch (Exception e) {
            result = null;
            this.logger.error((Object)"getDriver", (Throwable)e);
        }
        if (result != null && this.loader != null) {
            Thread.currentThread().setContextClassLoader(this.loader);
        }
        return result;
    }

    protected void resolve() {
        Object[] urls = null;
        try {
            if (this.url != null) {
                File f = new File(this.url);
                if (f.exists() && f.isDirectory()) {
                    File[] files = f.listFiles();
                    Vector<URL> myurls = new Vector<URL>();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isFile()) continue;
                            URL url = files[i].toURL();
                            myurls.add(url);
                        }
                    }
                    urls = new URL[myurls.size()];
                    myurls.copyInto(urls);
                } else {
                    File jar = new File(this.url);
                    URL url = jar.toURL();
                    urls = new URL[]{url};
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"resolve first phase", (Throwable)e);
        }
        try {
            ClassLoader cl = null;
            if (urls != null) {
                this.loader = cl = new URLClassLoader((URL[])urls, this.getClass().getClassLoader());
            } else {
                cl = this.getClass().getClassLoader();
            }
            this.driverClass = cl.loadClass(this.className);
        }
        catch (Exception e) {
            this.logger.error((Object)"resolve: second phase", (Throwable)e);
            System.err.println(e.getMessage());
        }
    }
}

