/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers;

import java.util.Hashtable;
import java.util.Properties;
import net.exogeni.orca.drivers.ActionOverlapTool;
import net.exogeni.orca.drivers.DriverExitCodes;
import net.exogeni.orca.drivers.DriverFactory;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.IDriver;
import net.exogeni.orca.drivers.util.EventLogger;
import org.apache.log4j.Logger;

public abstract class Driver
implements IDriver {
    protected Hashtable<String, Integer> map = new Hashtable();
    protected ThreadLocalEventLogger eventLogger = new ThreadLocalEventLogger();
    protected DriverId driverId;
    protected DriverFactory factory;
    protected Logger logger;
    protected ActionOverlapTool overlap;

    public Driver(DriverId driverId) {
        this.driverId = driverId;
        this.logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    }

    @Override
    public int initialize() throws Exception {
        int code = 0;
        if (this.overlap == null) {
            throw new Exception("Missing overlap object");
        }
        ((EventLoggerWrapper)this.eventLogger.get()).el = new EventLogger("initialize", "");
        return code;
    }

    @Override
    public int dispatch(String actionName, Properties in, Properties out) throws Exception {
        int code = 0;
        Integer actionID = this.map.get(actionName);
        if (actionID == null) {
            code = DriverExitCodes.UnknownAction;
            return code;
        }
        code = this.prepareDispatch(actionID, actionName, in, out);
        if (code != 0) {
            return code;
        }
        code = this.doDispatch(actionName, actionID, in, out);
        this.finishDispatch(actionName, actionID, in, out, code);
        return code;
    }

    @Override
    public int dispatch2(String objectId, String actionId, Properties in, Properties out) throws Exception {
        return 0;
    }

    protected abstract int doDispatch(String var1, Integer var2, Properties var3, Properties var4);

    protected abstract int prepareEventLogger(String var1, Integer var2, Properties var3);

    protected abstract String getActionKey(Integer var1, Properties var2);

    protected int prepareDispatch(Integer actionID, String actionName, Properties in, Properties out) {
        int code = 0;
        String actionKey = this.getActionKey(actionID, in);
        if (actionKey == null) {
            code = DriverExitCodes.InvalidArguments;
            return code;
        }
        code = this.overlap.actionStart(actionKey, actionID);
        if (code != 0) {
            return code;
        }
        code = this.prepareEventLogger(actionName, actionID, in);
        if (code != 0) {
            this.overlap.actionFinish(code, out);
        }
        return code;
    }

    protected void finishDispatch(String actionName, Integer actionID, Properties in, Properties out, int code) {
        this.overlap.actionFinish(code, out);
    }

    protected void setEventLogger(EventLogger el) {
        ((EventLoggerWrapper)this.eventLogger.get()).el = el;
    }

    public EventLogger getEventLogger() {
        return ((EventLoggerWrapper)this.eventLogger.get()).el;
    }

    @Override
    public int cleanup() throws Exception {
        return 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void setFactory(DriverFactory factory) {
        this.factory = factory;
    }

    public String getDriverRoot() {
        return this.factory.getDriverRoot(this);
    }

    @Override
    public DriverId getId() {
        return this.driverId;
    }

    public class ThreadLocalEventLogger
    extends ThreadLocal<EventLoggerWrapper> {
        @Override
        public EventLoggerWrapper initialValue() {
            return new EventLoggerWrapper();
        }
    }

    public class EventLoggerWrapper {
        public EventLogger el;
    }
}

