/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.drivers;

import java.util.Hashtable;
import java.util.Properties;
import net.exogeni.orca.drivers.Action;
import net.exogeni.orca.drivers.DriverExitCodes;
import org.apache.log4j.Logger;

public abstract class ActionOverlapTool {
    protected ThreadLocalAction myAction = new ThreadLocalAction();
    protected Hashtable<String, Action> pending = new Hashtable();
    protected Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int actionStart(String actionKey, Integer actionId) {
        Action current;
        int result = 0;
        Action previous = null;
        ((ActionWrapper)this.myAction.get()).action = current = new Action(actionKey, actionId, Thread.currentThread());
        this.logger.debug((Object)("starting an action: " + current.actionKey));
        boolean done = false;
        while (!done) {
            block17: {
                ActionOverlapTool actionOverlapTool = this;
                synchronized (actionOverlapTool) {
                    previous = this.pending.get(actionKey);
                    if (previous == null) {
                        this.logger.debug((Object)"addind an action record");
                        this.pending.put(actionKey, current);
                        done = true;
                    }
                }
                this.logger.debug((Object)"after checking pending list");
                if (previous == null) break block17;
                this.logger.debug((Object)"previous is not null");
                int code = this.handleOverlapAction(actionKey, previous, current);
                this.logger.debug((Object)("overlap code: " + code));
                switch (code) {
                    case 1: {
                        return result;
                    }
                    case 2: {
                        try {
                            Action action = previous;
                            synchronized (action) {
                                while (!previous.done) {
                                    previous.wait();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            return DriverExitCodes.ErrorInterrupted;
                        }
                        return result;
                    }
                    case 3: {
                        return DriverExitCodes.ErrorNotImplemented;
                    }
                    case 4: {
                        return DriverExitCodes.ErrorInvalidActionOverlap;
                    }
                }
                continue;
            }
            this.logger.debug((Object)("previous is null: done is " + done));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFinish(int code, Properties out) {
        Action action = ((ActionWrapper)this.myAction.get()).action;
        ((ActionWrapper)this.myAction.get()).action = null;
        this.logger.debug((Object)("action completing: " + action.actionKey));
        Object object = this;
        synchronized (object) {
            Action temp = this.pending.get(action.actionKey);
            if (temp == action) {
                this.logger.debug((Object)"removing action record");
                this.pending.remove(action.actionKey);
            } else {
                this.logger.debug((Object)"not removing action record!!!");
            }
        }
        object = action;
        synchronized (object) {
            action.exitCode = code;
            action.out = out;
            action.done = true;
            action.notify();
        }
    }

    public abstract int handleOverlapAction(String var1, Action var2, Action var3);

    protected class ThreadLocalAction
    extends ThreadLocal<ActionWrapper> {
        protected ThreadLocalAction() {
        }

        @Override
        public ActionWrapper initialValue() {
            return new ActionWrapper();
        }
    }

    protected class ActionWrapper {
        public Action action;

        protected ActionWrapper() {
        }
    }
}

