/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityBuilder;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.impl.BasicEntityFactory;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.AbstractDeserializer;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.vertx.java.core.buffer.Buffer;

public class JdomXmlDeserializer
extends AbstractDeserializer
implements Deserializer {
    private static final Namespace XSI_NAMESPACE = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final ContentType[] acceptable = new ContentType[]{ContentType.APPLICATION_XML_UTF8};
    private final EntityFactory factory;

    public JdomXmlDeserializer() {
        super(Arrays.asList(acceptable));
        this.factory = new BasicEntityFactory();
    }

    public JdomXmlDeserializer(EntityFactory factory) {
        super(Arrays.asList(acceptable));
        this.factory = factory;
    }

    @Override
    public Entity deserialize(Buffer body, ContentType contentType) throws DeserializationException {
        this.validate(body, contentType);
        return this.deserializeXml(body.getBytes(), contentType);
    }

    private Entity deserializeXml(byte[] body, ContentType contentType) throws DeserializationException {
        try {
            Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(body));
            Element root = d.getRootElement();
            return this.readEntity(root);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    private Entity readEntity(Element root) {
        EntityBuilder entity = this.factory.newEntity();
        this.readProperties(entity, root);
        this.readResources(entity, root);
        return entity.build();
    }

    private void readProperties(EntityBuilder entityBuilder, Element element) {
        List properties = element.getChildren();
        for (Element property : properties) {
            if (property.getChildren().size() != 0) continue;
            if (property.getAttribute("nil", XSI_NAMESPACE) != null) {
                entityBuilder.property(property.getName(), null);
                continue;
            }
            entityBuilder.property(property.getName(), (Object)property.getValue());
        }
    }

    private void readResources(EntityBuilder entityBuilder, Element element) {
        List resources = element.getChildren();
        for (Element resource : resources) {
            if (resource.getChildren().size() <= 0) continue;
            String rel = resource.getName();
            Entity subResource = this.readEntity(resource);
            entityBuilder.embed(rel, subResource);
        }
    }
}

