/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.AbstractSerializer;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;

public class JacksonJsonSerializer
extends AbstractSerializer
implements Serializer {
    protected static final MediaType[] mediaTypes = new MediaType[]{MediaType.APPLICATION_JSON};
    protected static final Charset[] charsets = new Charset[]{Charset.UTF8};

    public JacksonJsonSerializer() {
        super(Arrays.asList(mediaTypes), Arrays.asList(charsets));
    }

    @Override
    public Body serialize(Entity target, Set<AcceptableContentType> accept) throws ResponseException {
        Option<ContentType> contentType = this.resolveContentType(accept);
        this.validate(target, contentType);
        return this.serializeJson(target);
    }

    private Body serializeJson(Entity target) throws ResponseException {
        JsonFactory f = new JsonFactory();
        f.setCodec((ObjectCodec)new ObjectMapper());
        f.enable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator g = f.createGenerator((Writer)writer);
            g.writeStartObject();
            this.renderJson(g, target);
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            throw new ResponseException(e);
        }
        return new Body(writer.toString(), new ContentType(MediaType.APPLICATION_JSON, Charset.UTF8));
    }

    private void renderJson(JsonGenerator g, Entity representation) throws IOException {
        for (Map.Entry entry : representation.getProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            g.writeObjectField((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : representation.getRelations().entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                if (entry.getValue() == null) continue;
                for (Entity rep : (Collection)entry.getValue()) {
                    g.writeObjectFieldStart((String)entry.getKey());
                    this.renderJson(g, rep);
                    g.writeEndObject();
                }
                continue;
            }
            g.writeArrayFieldStart((String)entry.getKey());
            for (Entity subRepresentation : (Collection)entry.getValue()) {
                g.writeStartObject();
                this.renderJson(g, subRepresentation);
                g.writeEndObject();
            }
            g.writeEndArray();
        }
    }
}

