/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.theoryinpractise.halbuilder.impl.api.Support;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityBuilder;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.impl.BasicEntityFactory;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.AbstractDeserializer;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;
import org.vertx.java.core.buffer.Buffer;

public class JacksonJsonDeserializer
extends AbstractDeserializer
implements Deserializer {
    private static final ContentType[] acceptable = new ContentType[]{ContentType.APPLICATION_JSON_UTF8};
    private final EntityFactory factory;

    public JacksonJsonDeserializer() {
        super(Arrays.asList(acceptable));
        this.factory = new BasicEntityFactory();
    }

    public JacksonJsonDeserializer(EntityFactory factory) {
        super(Arrays.asList(acceptable));
        this.factory = factory;
    }

    @Override
    public Entity deserialize(Buffer body, ContentType contentType) throws DeserializationException {
        this.validate(body, contentType);
        return this.deserializeJson(body.getBytes(), contentType);
    }

    private Entity deserializeJson(byte[] body, ContentType contentType) throws DeserializationException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)mapper.readValue(body, JsonNode.class);
            return this.readEntity(rootNode);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    private Entity readEntity(JsonNode rootNode) {
        EntityBuilder entityBuilder = this.factory.newEntity();
        this.readProperties(entityBuilder, rootNode);
        this.readResources(entityBuilder, rootNode);
        return entityBuilder.build();
    }

    private void readProperties(EntityBuilder entityBuilder, JsonNode rootNode) {
        Iterator fieldNames = rootNode.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode field;
            String fieldName = (String)fieldNames.next();
            if (Support.RESERVED_JSON_PROPERTIES.contains(fieldName) || !(field = rootNode.get(fieldName)).isValueNode()) continue;
            entityBuilder.property(fieldName, (Object)(field.isNull() ? null : field.asText()));
        }
    }

    private void readResources(EntityBuilder entityBuilder, JsonNode rootNode) {
        Iterator fields = rootNode.fields();
        while (fields.hasNext()) {
            Map.Entry keyNode = (Map.Entry)fields.next();
            if (!((JsonNode)keyNode.getValue()).isArray() && !((JsonNode)keyNode.getValue()).isObject()) continue;
            if (((JsonNode)keyNode.getValue()).isArray()) {
                Iterator values = ((JsonNode)keyNode.getValue()).elements();
                while (values.hasNext()) {
                    JsonNode valueNode = (JsonNode)values.next();
                    entityBuilder.embed((String)keyNode.getKey(), this.readEntity(valueNode));
                }
                continue;
            }
            entityBuilder.embed((String)keyNode.getKey(), this.readEntity((JsonNode)keyNode.getValue()));
        }
    }
}

