/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.hal;

import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Arrays;
import java.util.Set;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.AbstractSerializer;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.http.serializer.hal.EntityRepresentationConverter;
import net.eusashead.parquet.util.Option;

public class HalSerializer
extends AbstractSerializer
implements Serializer {
    private static final MediaType[] mediaTypes = new MediaType[]{MediaType.APPLICATION_HAL_JSON, MediaType.APPLICATION_HAL_XML};
    protected static final Charset[] charsets = new Charset[]{Charset.UTF8};
    private final RepresentationFactory representationFactory;

    public HalSerializer() {
        super(Arrays.asList(mediaTypes), Arrays.asList(charsets));
        this.representationFactory = new StandardRepresentationFactory();
    }

    public HalSerializer(RepresentationFactory representationFactory) {
        super(Arrays.asList(mediaTypes), Arrays.asList(charsets));
        this.representationFactory = representationFactory;
    }

    @Override
    public Body serialize(Entity target, Set<AcceptableContentType> accept) throws ResponseException {
        Option<ContentType> contentType = this.resolveContentType(accept);
        this.validate(target, contentType);
        try {
            EntityRepresentationConverter converter = new EntityRepresentationConverter(this.representationFactory);
            Representation representation = converter.convert(target);
            return new Body(representation.toString(((ContentType)contentType.get()).mediaType().toString()), (ContentType)contentType.get());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseException(e);
        }
    }
}

