/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.hal;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.impl.BasicEntityFactory;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.AbstractDeserializer;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.hal.RepresentationEntityConverter;
import org.vertx.java.core.buffer.Buffer;

public class HalDeserializer
extends AbstractDeserializer
implements Deserializer {
    private static final ContentType[] acceptable = new ContentType[]{ContentType.HAL_JSON_UTF8, ContentType.HAL_XML_UTF8};
    private final RepresentationFactory representationFactory;
    private final EntityFactory entityFactory;

    public HalDeserializer() {
        super(Arrays.asList(acceptable));
        this.representationFactory = new StandardRepresentationFactory();
        this.entityFactory = new BasicEntityFactory();
    }

    public HalDeserializer(RepresentationFactory representationFactory) {
        super(Arrays.asList(acceptable));
        this.representationFactory = representationFactory;
        this.entityFactory = new BasicEntityFactory();
    }

    public HalDeserializer(RepresentationFactory representationFactory, EntityFactory entityFactory) {
        super(Arrays.asList(acceptable));
        this.representationFactory = representationFactory;
        this.entityFactory = entityFactory;
    }

    @Override
    public Entity deserialize(Buffer target, ContentType contentType) throws DeserializationException {
        this.validate(target, contentType);
        try {
            RepresentationEntityConverter converter = new RepresentationEntityConverter();
            ReadableRepresentation representation = this.representationFactory.readRepresentation((Reader)new StringReader(target.toString()));
            return converter.convert(representation, this.entityFactory).build();
        }
        catch (IllegalArgumentException e) {
            throw new DeserializationException(e);
        }
    }
}

