/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.hal;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import java.util.Collection;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.http.serializer.hal.RepresentationConverter;

public class EntityRepresentationConverter
implements RepresentationConverter<Entity> {
    private final RepresentationFactory representationFactory;

    public EntityRepresentationConverter(RepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
    }

    @Override
    public Representation convert(Entity source) {
        Representation representation = this.representationFactory.newRepresentation();
        for (Link link : source.getLinks().values()) {
            representation.withLink(link.rel(), link.href());
        }
        for (String name : source.getProperties().keySet()) {
            representation.withProperty(name, source.getProperty(name));
        }
        for (String rel : source.getRelations().keySet()) {
            Collection rels = source.getRelation(rel);
            for (Entity entity : rels) {
                Representation related = this.convert(entity);
                representation.withRepresentation(rel, (ReadableRepresentation)related);
            }
        }
        return representation;
    }
}

