/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer.composite;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.AbstractDeserializer;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;
import org.vertx.java.core.buffer.Buffer;

public class CompositeDeserializer
extends AbstractDeserializer
implements Deserializer {
    private final Map<ContentType, Deserializer> components = new ConcurrentHashMap<ContentType, Deserializer>();

    public CompositeDeserializer register(Deserializer component) {
        for (ContentType supported : component.contentTypes()) {
            this.supported.add(supported);
            this.components.put(supported, component);
        }
        return this;
    }

    @Override
    public Entity deserialize(Buffer body, ContentType contentType) throws DeserializationException {
        this.validate(body, contentType);
        try {
            Deserializer deserializer = this.components.get(contentType);
            return deserializer.deserialize(body, contentType);
        }
        catch (Exception t) {
            throw new DeserializationException(t);
        }
    }
}

