/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;

public abstract class AbstractSerializer
implements Serializer {
    protected final List<ContentType> supported = new ArrayList<ContentType>();

    public AbstractSerializer() {
    }

    public AbstractSerializer(List<MediaType> mediaTypes, List<Charset> charsets) {
        for (MediaType media : mediaTypes) {
            for (Charset charset : charsets) {
                ContentType contentType = new ContentType(media, charset);
                this.supported.add(contentType);
            }
        }
    }

    @Override
    public Option<ContentType> resolveContentType(Set<AcceptableContentType> accept) {
        for (AcceptableContentType acceptable : accept) {
            for (ContentType supported : this.supported) {
                if (!acceptable.contentType().compatible(supported)) continue;
                return Option.some((Object)supported);
            }
        }
        return Option.none();
    }

    @Override
    public boolean supports(ContentType contentType) {
        for (ContentType candidate : this.supported) {
            if (!contentType.compatible(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ContentType> contentTypes() {
        return Collections.unmodifiableList(this.supported);
    }

    protected void validate(Entity target, Option<ContentType> accept) throws ResponseException {
        if (target == null) {
            throw new ResponseException(HttpStatus.INTERNAL_SERVER_ERROR, "Cannot serialize a null Entity.");
        }
        if (accept == null || !accept.has()) {
            throw new ResponseException(HttpStatus.NOT_ACCEPTABLE, "Not acceptable");
        }
    }
}

