/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.serializer.DeserializationException;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.util.Assert;
import org.vertx.java.core.buffer.Buffer;

public abstract class AbstractDeserializer
implements Deserializer {
    protected final List<ContentType> supported;

    public AbstractDeserializer() {
        this.supported = new ArrayList<ContentType>();
    }

    public AbstractDeserializer(List<ContentType> supported) {
        this.supported = supported;
    }

    @Override
    public boolean supports(ContentType contentType) {
        return this.supported.contains(contentType);
    }

    @Override
    public List<ContentType> contentTypes() {
        return Collections.unmodifiableList(this.supported);
    }

    protected void validate(Buffer body, ContentType contentType) throws DeserializationException {
        try {
            Assert.notNull((Object)body);
            Assert.notNull((Object)contentType);
            Assert.isTrue((boolean)this.supports(contentType), (String)String.format("Deserializer %s does not support content type %s", this.getClass(), contentType));
        }
        catch (RuntimeException e) {
            throw new DeserializationException(e);
        }
    }
}

