/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.response.impl;

import net.eusashead.parquet.http.header.ResponseHeaders;
import net.eusashead.parquet.http.response.Response;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerResponse;

public class ResponseImpl
implements Response {
    private final HttpServerResponse response;
    private final ResponseHeaders headers;
    private boolean committed = false;

    public ResponseImpl(HttpServerResponse response) {
        this.response = response;
        this.headers = new ResponseHeaders(response.headers());
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public ResponseImpl setStatusCode(int statusCode) {
        this.response.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        return this.response.getStatusMessage();
    }

    public ResponseImpl setStatusMessage(String statusMessage) {
        this.response.setStatusMessage(statusMessage);
        return this;
    }

    public ResponseImpl setChunked(boolean chunked) {
        this.response.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        return this.response.isChunked();
    }

    public ResponseImpl putHeader(String name, String value) {
        this.response.putHeader(name, value);
        return this;
    }

    public ResponseImpl putHeader(String name, Iterable<String> values) {
        this.response.putHeader(name, values);
        return this;
    }

    public MultiMap trailers() {
        return this.response.trailers();
    }

    public ResponseImpl putTrailer(String name, String value) {
        this.response.putTrailer(name, value);
        return this;
    }

    public ResponseImpl putTrailer(String name, Iterable<String> values) {
        this.response.putTrailer(name, values);
        return this;
    }

    public ResponseImpl closeHandler(Handler<Void> handler) {
        this.response.closeHandler(handler);
        return this;
    }

    public ResponseImpl write(Buffer chunk) {
        this.response.write(chunk);
        return this;
    }

    public ResponseImpl write(String chunk, String enc) {
        this.response.write(chunk, enc);
        return this;
    }

    public ResponseImpl write(String chunk) {
        this.response.write(chunk);
        return this;
    }

    public void end(String chunk) {
        this.response.end(chunk);
        this.committed = true;
    }

    public void end(String chunk, String enc) {
        this.response.end(chunk, enc);
        this.committed = true;
    }

    public void end(Buffer chunk) {
        this.response.end(chunk);
        this.committed = true;
    }

    public void end() {
        this.response.end();
        this.committed = true;
    }

    public ResponseImpl sendFile(String filename) {
        this.response.sendFile(filename);
        this.committed = true;
        return this;
    }

    public ResponseImpl sendFile(String filename, String notFoundFile) {
        this.response.sendFile(filename, notFoundFile);
        this.committed = true;
        return this;
    }

    public ResponseImpl sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.response.sendFile(filename, resultHandler);
        this.committed = true;
        return this;
    }

    public ResponseImpl sendFile(String filename, String notFoundFile, Handler<AsyncResult<Void>> resultHandler) {
        this.response.sendFile(filename, notFoundFile, resultHandler);
        this.committed = true;
        return this;
    }

    public void close() {
        this.response.close();
    }

    public ResponseImpl exceptionHandler(Handler<Throwable> handler) {
        this.response.exceptionHandler(handler);
        return this;
    }

    public ResponseImpl setWriteQueueMaxSize(int maxSize) {
        this.response.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.response.writeQueueFull();
    }

    public ResponseImpl drainHandler(Handler<Void> handler) {
        this.response.drainHandler(handler);
        return this;
    }

    @Override
    public ResponseHeaders headers() {
        return this.headers;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    public ResponseImpl putHeader(CharSequence name, CharSequence value) {
        this.response.putHeader(name, value);
        return this;
    }

    public ResponseImpl putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.response.putHeader(name, values);
        return this;
    }

    public ResponseImpl putTrailer(CharSequence name, CharSequence value) {
        this.response.putTrailer(name, value);
        return this;
    }

    public ResponseImpl putTrailer(CharSequence name, Iterable<CharSequence> values) {
        this.response.putTrailer(name, values);
        return this;
    }
}

