/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.response.impl;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.etag.ETag;
import net.eusashead.parquet.http.etag.ETagValidation;
import net.eusashead.parquet.http.handler.PreconditionSuccessHandler;
import net.eusashead.parquet.http.header.RequestHeaders;
import net.eusashead.parquet.http.request.Request;
import net.eusashead.parquet.http.response.Response;
import net.eusashead.parquet.http.response.impl.ResponseBuilderImpl;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;
import org.vertx.java.core.logging.Logger;

public class GetResponseBuilderImpl
extends ResponseBuilderImpl {
    public GetResponseBuilderImpl(Request request, Response response, EntityFactory entityFactory, Serializer serializer, HashStrategy hashStrategy, Logger logger) {
        super(request, response, entityFactory, serializer, hashStrategy, logger);
    }

    @Override
    public void send() {
        Body body = this.serialize();
        this.addVaryHeader();
        if (!this.response.isCommitted()) {
            if (this.request.method().equals(HttpMethod.GET.toString())) {
                this.response.setStatusCode(HttpStatus.OK.getCode()).end(body.buffer());
            } else {
                if (!this.response.isChunked()) {
                    this.response.headers().add("Content-Length", String.valueOf(body.length()));
                }
                this.response.setStatusCode(HttpStatus.OK.getCode()).write("").end();
            }
        }
    }

    @Override
    public void checkPrecondition(Option<ETag> eTag, Option<HttpDate> lastModified, PreconditionSuccessHandler handler, boolean require) {
        RequestHeaders headers = this.request.headers();
        if (!(!require || headers.hasIfMatch() || headers.hasIfNoneMatch() || headers.hasIfModifiedSince() || headers.hasIfUnmodifiedSince())) {
            this.request.error(HttpStatus.PRECONDITION_REQUIRED).send();
        } else {
            if (headers.hasIfMatch() && !headers.checkIfMatch(eTag, ETagValidation.WEAK)) {
                this.request.error(HttpStatus.PRECONDITION_FAILED).send();
                return;
            }
            if (headers.hasIfUnmodifiedSince() && !headers.checkIfUnmodifiedSince(lastModified)) {
                this.request.error(HttpStatus.PRECONDITION_FAILED).send();
                return;
            }
            if (headers.hasIfNoneMatch()) {
                if (headers.ifNoneMatch().isWildcard()) {
                    if (!headers.hasIfModifiedSince() || !headers.checkIfModifiedSince(lastModified)) {
                        this.addVaryHeader();
                        this.request.response().setStatusCode(HttpStatus.NOT_MODIFIED.getCode()).end();
                        return;
                    }
                } else if (!headers.checkIfNoneMatch(eTag, ETagValidation.WEAK)) {
                    this.addVaryHeader();
                    this.request.response().setStatusCode(HttpStatus.NOT_MODIFIED.getCode()).end();
                    return;
                }
            }
            if (headers.hasIfModifiedSince() && !headers.checkIfModifiedSince(lastModified)) {
                this.addVaryHeader();
                this.request.response().setStatusCode(HttpStatus.NOT_MODIFIED.getCode()).end();
                return;
            }
            handler.handle();
        }
    }
}

