/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.request.impl;

import com.jetdrone.vertx.yoke.middleware.YokeCookie;
import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableCharset;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.conneg.AcceptableLanguage;
import net.eusashead.parquet.http.conneg.AcceptableMediaType;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.header.RequestHeaders;
import net.eusashead.parquet.http.request.Request;
import net.eusashead.parquet.http.response.ErrorResponseBuilder;
import net.eusashead.parquet.http.response.Response;
import net.eusashead.parquet.http.response.impl.ErrorResponseBuilderImpl;
import net.eusashead.parquet.http.response.impl.ResponseImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.HttpVersion;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.net.NetSocket;

public abstract class RequestImpl
implements Request {
    protected final YokeRequest request;
    protected final RequestHeaders headers;
    protected final Deserializer deserializer;
    protected final Serializer serializer;
    protected final EntityFactory entityFactory;
    protected final MediaTypeStrategy mediaTypeStrategy;
    protected final HashStrategy hashStrategy;
    protected final Response response;
    protected final Logger logger;
    protected final ErrorResponseBuilder errorResponseBuilder;

    public RequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy, HashStrategy hashStrategy, Logger logger) {
        this.request = request;
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.entityFactory = entityFactory;
        this.mediaTypeStrategy = mediaTypeStrategy;
        this.hashStrategy = hashStrategy;
        this.logger = logger;
        this.response = new ResponseImpl((HttpServerResponse)request.response());
        this.headers = new RequestHeaders(request.headers());
        this.errorResponseBuilder = new ErrorResponseBuilderImpl(this, this.response, entityFactory, serializer, hashStrategy, logger);
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    public MultiMap params() {
        return this.request.params();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public ErrorResponseBuilder error(HttpStatus status) {
        return this.errorResponseBuilder.status(status);
    }

    @Override
    public Set<AcceptableCharset> acceptableCharsets() {
        TreeSet<AcceptableCharset> acceptable = new TreeSet<AcceptableCharset>();
        String acceptHeader = this.headers.get("Accept-Charset");
        try {
            if (acceptHeader != null) {
                for (String accept : acceptHeader.split(",")) {
                    AcceptableCharset a = AcceptableCharset.parse(accept);
                    acceptable.add(a);
                }
            } else {
                AcceptableCharset a = new AcceptableCharset(1.0, Charset.ANY);
                acceptable.add(a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return acceptable;
    }

    @Override
    public Set<AcceptableLanguage> acceptableLanguages() {
        TreeSet<AcceptableLanguage> acceptable = new TreeSet<AcceptableLanguage>();
        String acceptHeader = this.headers.get("Accept-Language");
        try {
            if (acceptHeader != null) {
                for (String accept : acceptHeader.split(",")) {
                    AcceptableLanguage a = AcceptableLanguage.parse(accept);
                    acceptable.add(a);
                }
            } else {
                acceptable.add(new AcceptableLanguage(1.0, Locale.getDefault()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return acceptable;
    }

    @Override
    public Set<AcceptableMediaType> acceptableMediaType() {
        try {
            Set<AcceptableMediaType> acceptable = this.mediaTypeStrategy.acceptableMediaTypes((HttpServerRequest)this.request);
            if (acceptable.size() == 0) {
                acceptable.add(new AcceptableMediaType(1.0, MediaType.ANY));
            }
            return acceptable;
        }
        catch (Exception e) {
            return new TreeSet<AcceptableMediaType>();
        }
    }

    @Override
    public Set<AcceptableContentType> acceptableContentType() {
        TreeSet<AcceptableContentType> acceptable = new TreeSet<AcceptableContentType>();
        for (AcceptableMediaType mediaType : this.acceptableMediaType()) {
            for (AcceptableCharset charset : this.acceptableCharsets()) {
                double q = charset.q() * mediaType.q();
                ContentType contentType = new ContentType(mediaType.mediaType(), charset.charset());
                acceptable.add(new AcceptableContentType(q, contentType));
            }
        }
        return acceptable;
    }

    @Override
    public Response response() {
        return this.response;
    }

    public HttpVersion version() {
        return this.request.version();
    }

    public String method() {
        return this.request.method();
    }

    public String uri() {
        return this.request.uri();
    }

    public String path() {
        return this.request.path();
    }

    public String query() {
        return this.request.query();
    }

    public InetSocketAddress remoteAddress() {
        return this.request.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return this.request.localAddress();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.request.peerCertificateChain();
    }

    public URI absoluteURI() {
        return this.request.absoluteURI();
    }

    public RequestImpl bodyHandler(Handler<Buffer> bodyHandler) {
        this.request.bodyHandler(bodyHandler);
        return this;
    }

    public NetSocket netSocket() {
        return this.request.netSocket();
    }

    public RequestImpl expectMultiPart(boolean expect) {
        this.request.expectMultiPart(expect);
        return this;
    }

    public RequestImpl uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
        this.request.uploadHandler(uploadHandler);
        return this;
    }

    public MultiMap formAttributes() {
        return this.request.formAttributes();
    }

    public RequestImpl endHandler(Handler<Void> endHandler) {
        this.request.endHandler(endHandler);
        return this;
    }

    public RequestImpl dataHandler(Handler<Buffer> handler) {
        this.request.dataHandler(handler);
        return this;
    }

    public RequestImpl pause() {
        this.request.pause();
        return this;
    }

    public RequestImpl resume() {
        this.request.resume();
        return this;
    }

    public RequestImpl exceptionHandler(Handler<Throwable> handler) {
        this.request.exceptionHandler(handler);
        return this;
    }

    @Override
    public <R> R get(String name) {
        return (R)this.request.get(name);
    }

    @Override
    public <R> R get(String name, R defaultValue) {
        return (R)this.request.get(name, defaultValue);
    }

    @Override
    public <R> R put(String name, R value) {
        return (R)this.request.put(name, value);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public List<String> getAllHeaders(String name) {
        return this.request.getAllHeaders(name);
    }

    @Override
    public String getHeader(String name, String defaultValue) {
        return this.request.getHeader(name, defaultValue);
    }

    @Override
    public Set<YokeCookie> cookies() {
        return this.request.cookies();
    }

    @Override
    public YokeCookie getCookie(String name) {
        return this.request.getCookie(name);
    }

    @Override
    public List<YokeCookie> getAllCookies(String name) {
        return this.request.getAllCookies(name);
    }
}

