/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.request.impl;

import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.request.BodyRequest;
import net.eusashead.parquet.http.request.impl.RequestImpl;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.logging.Logger;

public abstract class BodyRequestImpl
extends RequestImpl
implements BodyRequest {
    private Entity entity;

    public BodyRequestImpl(YokeRequest request, Deserializer deserializer, Serializer serializer, EntityFactory entityFactory, MediaTypeStrategy mediaTypeStrategy, HashStrategy hashStrategy, Logger logger) {
        super(request, deserializer, serializer, entityFactory, mediaTypeStrategy, hashStrategy, logger);
        this.entityHandler(new Handler<Entity>(){

            public void handle(Entity event) {
                BodyRequestImpl.this.entity = event;
            }
        });
    }

    @Override
    public BodyRequest entityHandler(final Handler<Entity> handler) {
        this.request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                try {
                    Option<ContentType> contentType = BodyRequestImpl.this.headers.contentType();
                    if (contentType.has() && BodyRequestImpl.this.deserializer.supports((ContentType)contentType.get())) {
                        BodyRequestImpl.this.entity = BodyRequestImpl.this.deserializer.deserialize(buffer, (ContentType)contentType.get());
                        handler.handle((Object)BodyRequestImpl.this.entity);
                    } else {
                        BodyRequestImpl.this.error(HttpStatus.UNSUPPORTED_MEDIA_TYPE).send();
                    }
                }
                catch (Exception e) {
                    BodyRequestImpl.this.logger.warn((Object)("Invalid request body: " + buffer.toString()));
                    BodyRequestImpl.this.error(HttpStatus.BAD_REQUEST).send();
                }
            }
        });
        return this;
    }

    @Override
    public Entity body() {
        return this.entity;
    }
}

