/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.header;

import java.net.URI;
import java.util.Arrays;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.HttpMethods;
import net.eusashead.parquet.http.etag.ETag;
import net.eusashead.parquet.http.etag.impl.BasicETag;
import net.eusashead.parquet.http.header.AbstractHeaders;
import net.eusashead.parquet.util.Option;
import org.vertx.java.core.MultiMap;

public class ResponseHeaders
extends AbstractHeaders {
    public ResponseHeaders(MultiMap headers) {
        super(headers);
    }

    public Option<ETag> eTag() {
        try {
            return Option.some((Object)BasicETag.parse(this.headers.get("ETag")));
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public ResponseHeaders eTag(ETag eTag) {
        this.headers.add("ETag", eTag.encode());
        return this;
    }

    public Option<HttpDate> lastModified() {
        try {
            HttpDate date = HttpDate.parse(this.headers.get("Last-Modified"));
            return Option.some((Object)date);
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public ResponseHeaders lastModified(HttpDate date) {
        this.headers.add("Last-Modified", date.toString());
        return this;
    }

    public Option<URI> location() {
        try {
            return Option.some((Object)URI.create(this.headers.get("Location")));
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public ResponseHeaders location(URI location) {
        this.headers.add("Location", location.toString());
        return this;
    }

    public HttpMethods allow() {
        return HttpMethods.parse(this.headers.get("Allow"));
    }

    public ResponseHeaders allow(HttpMethod ... methods) {
        HttpMethods header = new HttpMethods(Arrays.asList(methods));
        this.headers.add("Allow", header.toString());
        return this;
    }

    public ResponseHeaders allow(HttpMethods methods) {
        this.headers.add("Allow", methods.toString());
        return this;
    }

    public Option<ContentType> contentType() {
        try {
            return Option.some((Object)ContentType.parse(this.headers.get("Content-Type")));
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public ResponseHeaders contentType(ContentType contentType) {
        this.headers.add("Content-Type", contentType.toString());
        return this;
    }

    public boolean hasETag() {
        return this.has("ETag");
    }

    public boolean hasLastModified() {
        return this.has("Last-Modified");
    }

    public boolean hasContentType() {
        return this.has("Content-Type");
    }

    public boolean hasAllow() {
        return this.has("Allow");
    }

    public boolean hasLocation() {
        return this.has("Location");
    }
}

