/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.header;

import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.etag.ETag;
import net.eusashead.parquet.http.etag.ETagValidation;
import net.eusashead.parquet.http.header.AbstractHeaders;
import net.eusashead.parquet.http.header.MatchHeader;
import net.eusashead.parquet.util.Function;
import net.eusashead.parquet.util.Option;
import org.vertx.java.core.MultiMap;

public class RequestHeaders
extends AbstractHeaders {
    public RequestHeaders(MultiMap headers) {
        super(headers);
    }

    public Option<ContentType> contentType() {
        try {
            ContentType contentType = ContentType.parse(this.headers.get("Content-Type"));
            return Option.some((Object)contentType);
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public Option<HttpDate> ifModifiedSince() {
        return this.parseHttpDate(this.headers.get("If-Modified-Since"));
    }

    public Option<HttpDate> ifUnmodifiedSince() {
        return this.parseHttpDate(this.headers.get("If-Unmodified-Since"));
    }

    private Option<HttpDate> parseHttpDate(String httpDateString) {
        try {
            HttpDate date = HttpDate.parse(httpDateString);
            return Option.some((Object)date);
        }
        catch (Exception e) {
            return Option.none();
        }
    }

    public boolean checkIfModifiedSince(final Option<HttpDate> lastModified) {
        return (Boolean)this.ifModifiedSince().maybe((Object)true, (Function)new Function<Boolean, HttpDate>(){

            public Boolean apply(final HttpDate ifModifiedSince) {
                return (Boolean)lastModified.maybe((Object)true, (Function)new Function<Boolean, HttpDate>(){

                    public Boolean apply(HttpDate lastModified) {
                        return lastModified.after(ifModifiedSince);
                    }
                });
            }
        });
    }

    public boolean checkIfUnmodifiedSince(final Option<HttpDate> lastModified) {
        return (Boolean)this.ifUnmodifiedSince().maybe((Object)true, (Function)new Function<Boolean, HttpDate>(){

            public Boolean apply(final HttpDate ifUnmodifiedSince) {
                return (Boolean)lastModified.maybe((Object)false, (Function)new Function<Boolean, HttpDate>(){

                    public Boolean apply(HttpDate lastModified) {
                        return lastModified.equals(ifUnmodifiedSince) || lastModified.before(ifUnmodifiedSince);
                    }
                });
            }
        });
    }

    public boolean checkIfNoneMatch(Option<ETag> eTag, ETagValidation type) {
        MatchHeader etags = this.parseEtags("If-None-Match");
        if (etags.isEmpty()) {
            return true;
        }
        return !etags.match(eTag, type);
    }

    public boolean checkIfMatch(Option<ETag> eTag, ETagValidation type) {
        MatchHeader etags = this.parseEtags("If-Match");
        if (etags.isEmpty()) {
            return true;
        }
        return etags.match(eTag, type);
    }

    private MatchHeader parseEtags(String header) {
        String parse = this.headers.get(header);
        return MatchHeader.parse(parse);
    }

    public boolean hasIfMatch() {
        return this.has("If-Match");
    }

    public boolean hasIfNoneMatch() {
        return this.has("If-None-Match");
    }

    public boolean hasIfModifiedSince() {
        return this.has("If-Modified-Since");
    }

    public boolean hasIfUnmodifiedSince() {
        return this.has("If-Unmodified-Since");
    }

    public RequestHeaders ifModifiedSince(HttpDate httpDate) {
        this.headers.add("If-Modified-Since", httpDate.toString());
        return this;
    }

    public RequestHeaders ifUnmodifiedSince(HttpDate httpDate) {
        this.headers.add("If-Unmodified-Since", httpDate.toString());
        return this;
    }

    public MatchHeader ifNoneMatch() {
        return this.parseEtags("If-None-Match");
    }

    public MatchHeader ifMatch() {
        return this.parseEtags("If-Match");
    }

    public RequestHeaders ifNoneMatch(ETag eTag) {
        this.headers.add("If-None-Match", eTag.toString());
        return this;
    }

    public RequestHeaders ifNoneMatch(MatchHeader eTags) {
        this.headers.add("If-None-Match", eTags.encode());
        return this;
    }

    public RequestHeaders ifMatch(ETag eTag) {
        this.headers.add("If-Match", eTag.toString());
        return this;
    }

    public RequestHeaders ifMatch(MatchHeader eTags) {
        this.headers.add("If-Match", eTags.encode());
        return this;
    }
}

