/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.eusashead.parquet.http.etag.ETag;
import net.eusashead.parquet.http.etag.ETagValidation;
import net.eusashead.parquet.http.etag.impl.BasicETag;
import net.eusashead.parquet.util.Function;
import net.eusashead.parquet.util.Option;
import org.apache.commons.lang3.StringUtils;

public class MatchHeader {
    private final String value;

    private MatchHeader(String value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this.value == null || this.value.length() == 0;
    }

    public boolean isWildcard() {
        return "*".equals(this.value);
    }

    public List<ETag> eTags() {
        ArrayList<ETag> list = new ArrayList<ETag>();
        List<String> eTags = this.eTagValues();
        for (String eTag : eTags) {
            if (eTag == null) continue;
            try {
                list.add(BasicETag.parse(eTag));
            }
            catch (Exception e) {}
        }
        return list;
    }

    private List<String> eTagValues() {
        String[] eTags = new String[]{};
        if (this.value != null) {
            eTags = StringUtils.split((String)StringUtils.deleteWhitespace((String)this.value), (String)",");
        }
        return Arrays.asList(eTags);
    }

    public boolean matchWeak(Option<ETag> eTag) {
        if (eTag == null || this.isEmpty()) {
            return false;
        }
        if (this.isWildcard()) {
            return true;
        }
        return (Boolean)eTag.maybe((Object)true, (Function)new Function<Boolean, ETag>(){

            public Boolean apply(ETag f) {
                for (ETag candidate : MatchHeader.this.eTags()) {
                    if (!f.weakEquals(candidate)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    public boolean matchStrong(Option<ETag> eTag) {
        if (eTag == null || this.isEmpty()) {
            return false;
        }
        if (this.isWildcard()) {
            return true;
        }
        return (Boolean)eTag.maybe((Object)true, (Function)new Function<Boolean, ETag>(){

            public Boolean apply(ETag f) {
                for (ETag candidate : MatchHeader.this.eTags()) {
                    if (!f.strongEquals(candidate)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    public boolean match(Option<ETag> eTag, ETagValidation type) {
        if (type == ETagValidation.STRONG) {
            return this.matchStrong(eTag);
        }
        return this.matchWeak(eTag);
    }

    public String toString() {
        return this.encode();
    }

    public String encode() {
        return this.value;
    }

    public static MatchHeader createWildcard() {
        MatchHeader etags = new MatchHeader("*");
        return etags;
    }

    public static MatchHeader createEmpty() {
        MatchHeader etags = new MatchHeader("");
        return etags;
    }

    public static MatchHeader create(List<ETag> list) {
        StringBuilder encode = new StringBuilder();
        for (ETag eTag : list) {
            encode.append(eTag.encode());
            encode.append(", ");
        }
        encode.delete(encode.lastIndexOf(","), encode.length());
        return new MatchHeader(encode.toString());
    }

    public static MatchHeader parse(String header) {
        return new MatchHeader(header);
    }
}

