/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.etag.impl;

import java.nio.charset.Charset;
import java.util.Date;
import net.eusashead.parquet.http.etag.ETag;
import net.eusashead.parquet.http.etag.ETagValidation;
import net.eusashead.parquet.util.Assert;
import org.apache.commons.lang3.StringUtils;

public class BasicETag
implements ETag {
    private static final String WILDCARD = "*";
    private static final String WEAK_PREFIX = "W/\"";
    private static final String STRONG_PREFIX = "\"";
    private static final String POST_FIX = "\"";
    private final ETagValidation type;
    private final String value;

    public BasicETag(Date date) {
        this(ETagValidation.WEAK, new Long(date.getTime()).toString());
    }

    public BasicETag(Long version) {
        this(ETagValidation.STRONG, version.toString());
    }

    public BasicETag(Integer version) {
        this(ETagValidation.STRONG, version.toString());
    }

    public BasicETag(byte[] hash) {
        this(ETagValidation.STRONG, new String(hash, Charset.forName("utf-8")));
    }

    public BasicETag(ETagValidation type, String value) {
        Assert.notNull((Object)((Object)type));
        Assert.notNull((Object)value);
        this.type = type;
        this.value = value;
    }

    @Override
    public ETagValidation type() {
        return this.type;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean weakEquals(ETag eTag) {
        if (eTag == null) {
            return false;
        }
        if (this.value.equals(WILDCARD) || eTag.value().equals(WILDCARD)) {
            return true;
        }
        return this.value.equals(eTag.value());
    }

    @Override
    public boolean strongEquals(ETag eTag) {
        if (eTag == null) {
            return false;
        }
        if (this.value.equals(WILDCARD) || eTag.value().equals(WILDCARD)) {
            return true;
        }
        if (this.type == ETagValidation.STRONG && eTag.type() == ETagValidation.STRONG) {
            return this.value.equals(eTag.value());
        }
        return false;
    }

    @Override
    public boolean weakEquals(String encoded) {
        return this.weakEquals(BasicETag.parse(encoded));
    }

    @Override
    public boolean strongEquals(String encoded) {
        return this.strongEquals(BasicETag.parse(encoded));
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        if (this.type == ETagValidation.WEAK) {
            builder.append(WEAK_PREFIX);
        } else {
            builder.append("\"");
        }
        builder.append(this.value);
        builder.append("\"");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicETag other = (BasicETag)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.encode();
    }

    public static ETag parse(String value) {
        String parsed;
        ETagValidation validation;
        BasicETag eTag = null;
        if (BasicETag.validate(value)) {
            if (value.equals(WILDCARD)) {
                validation = ETagValidation.STRONG;
                parsed = WILDCARD;
            } else if (value.startsWith(WEAK_PREFIX)) {
                validation = ETagValidation.WEAK;
                parsed = value.substring(WEAK_PREFIX.length(), value.length() - 1);
            } else {
                validation = ETagValidation.STRONG;
                parsed = value.substring(1, value.length() - 1);
            }
        } else {
            throw new IllegalArgumentException(String.format("%s is not a valid ETag value.", value));
        }
        eTag = new BasicETag(validation, parsed);
        return eTag;
    }

    private static boolean validate(String candidate) {
        return candidate != null && candidate.equals(WILDCARD) || candidate.length() > 2 && candidate.endsWith("\"") && (candidate.startsWith(WEAK_PREFIX) || candidate.startsWith("\"") && StringUtils.countMatches((CharSequence)candidate, (CharSequence)"\"") == 2);
    }
}

