/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.container;

import com.jetdrone.vertx.yoke.Middleware;
import com.jetdrone.vertx.yoke.middleware.Router;
import java.util.ArrayList;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.impl.BasicEntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.hash.impl.Murmur3HashStrategy;
import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.conneg.MediaTypeStrategy;
import net.eusashead.parquet.http.conneg.impl.AcceptHeaderMediaTypeStrategy;
import net.eusashead.parquet.http.container.MethodNotAllowedHandler;
import net.eusashead.parquet.http.container.NotImplementedHandler;
import net.eusashead.parquet.http.container.OptionsHandler;
import net.eusashead.parquet.http.container.TraceHandler;
import net.eusashead.parquet.http.handler.DeleteRequestHandler;
import net.eusashead.parquet.http.handler.DeleteRequestHandlerDelegator;
import net.eusashead.parquet.http.handler.GetRequestHandler;
import net.eusashead.parquet.http.handler.GetRequestHandlerDelegator;
import net.eusashead.parquet.http.handler.OptionsRequestHandler;
import net.eusashead.parquet.http.handler.OptionsRequestHandlerDelegator;
import net.eusashead.parquet.http.handler.PatchRequestHandler;
import net.eusashead.parquet.http.handler.PatchRequestHandlerDelegator;
import net.eusashead.parquet.http.handler.PostRequestHandler;
import net.eusashead.parquet.http.handler.PostRequestHandlerDelegator;
import net.eusashead.parquet.http.handler.PutRequestHandler;
import net.eusashead.parquet.http.handler.PutRequestHandlerDelegator;
import net.eusashead.parquet.http.resource.DeleteResource;
import net.eusashead.parquet.http.resource.OptionsResource;
import net.eusashead.parquet.http.resource.PatchResource;
import net.eusashead.parquet.http.resource.PostResource;
import net.eusashead.parquet.http.resource.PutResource;
import net.eusashead.parquet.http.resource.Resource;
import net.eusashead.parquet.http.serializer.Deserializer;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.http.serializer.composite.CompositeDeserializer;
import net.eusashead.parquet.http.serializer.composite.CompositeSerializer;
import net.eusashead.parquet.util.Assert;
import org.vertx.java.core.Handler;
import org.vertx.java.core.logging.Logger;

public class RouterBuilder {
    private final Logger logger;
    private final Router router;
    private final CompositeSerializer serializer = new CompositeSerializer();
    private final CompositeDeserializer deserializer = new CompositeDeserializer();
    private MediaTypeStrategy mediaTypeStrategy = new AcceptHeaderMediaTypeStrategy();
    private EntityFactory entityFactory = new BasicEntityFactory();
    private HashStrategy hashStrategy = new Murmur3HashStrategy();
    private boolean traceSupported = false;

    public RouterBuilder(Logger logger) {
        this.logger = logger;
        this.router = new Router();
    }

    public RouterBuilder registerSerializer(Serializer serializer) {
        Assert.notNull((Object)serializer);
        this.serializer.register(serializer);
        return this;
    }

    public RouterBuilder registerDeserializer(Deserializer deserializer) {
        Assert.notNull((Object)deserializer);
        this.deserializer.register(deserializer);
        return this;
    }

    public RouterBuilder entityFactory(EntityFactory entityFactory) {
        Assert.notNull((Object)entityFactory);
        this.entityFactory = entityFactory;
        return this;
    }

    public RouterBuilder hashStrategy(HashStrategy hashStrategy) {
        Assert.notNull((Object)hashStrategy);
        this.hashStrategy = hashStrategy;
        return this;
    }

    public RouterBuilder mediaTypeStrategy(MediaTypeStrategy mediaTypeStrategy) {
        Assert.notNull((Object)mediaTypeStrategy);
        this.mediaTypeStrategy = mediaTypeStrategy;
        return this;
    }

    public RouterBuilder supportTrace(boolean traceSupported) {
        this.traceSupported = traceSupported;
        return this;
    }

    public Router router() {
        return this.router;
    }

    public RouterBuilder registerResource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null.");
        Assert.notEmpty((String)resource.uri(), (String)"Resource URI must not be null.");
        if (!this.traceSupported) {
            this.router.trace(".*", (Handler)new NotImplementedHandler());
        }
        this.router.connect(".*", (Handler)new NotImplementedHandler());
        ArrayList<HttpMethod> supported = new ArrayList<HttpMethod>();
        ArrayList<HttpMethod> unsupported = new ArrayList<HttpMethod>();
        GetRequestHandler getHandler = resource.get();
        Assert.notNull((Object)getHandler, (String)"GET Handler must not be null.");
        this.router.get(resource.uri(), new Middleware[]{new GetRequestHandlerDelegator(getHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
        this.router.head(resource.uri(), new Middleware[]{new GetRequestHandlerDelegator(getHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
        supported.add(HttpMethod.GET);
        supported.add(HttpMethod.HEAD);
        if (resource instanceof PutResource) {
            PutResource put = (PutResource)PutResource.class.cast(resource);
            PutRequestHandler putHandler = put.put();
            Assert.notNull((Object)putHandler, (String)"PUT Handler must not be null.");
            this.router.put(resource.uri(), new Middleware[]{new PutRequestHandlerDelegator(putHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
            supported.add(HttpMethod.PUT);
        } else {
            unsupported.add(HttpMethod.PUT);
        }
        if (resource instanceof PatchResource) {
            PatchResource patch = (PatchResource)PatchResource.class.cast(resource);
            PatchRequestHandler patchHandler = patch.patch();
            Assert.notNull((Object)patchHandler, (String)"PATCH Handler must not be null.");
            this.router.patch(resource.uri(), new Middleware[]{new PatchRequestHandlerDelegator(patchHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
            supported.add(HttpMethod.PATCH);
        } else {
            unsupported.add(HttpMethod.PATCH);
        }
        if (resource instanceof DeleteResource) {
            DeleteResource delete = (DeleteResource)DeleteResource.class.cast(resource);
            DeleteRequestHandler deleteHandler = delete.delete();
            Assert.notNull((Object)deleteHandler, (String)"DELETE Handler must not be null.");
            this.router.delete(resource.uri(), new Middleware[]{new DeleteRequestHandlerDelegator(deleteHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
            supported.add(HttpMethod.DELETE);
        } else {
            unsupported.add(HttpMethod.DELETE);
        }
        if (resource instanceof PostResource) {
            PostResource post = (PostResource)PostResource.class.cast(resource);
            PostRequestHandler postHandler = post.post();
            Assert.notNull((Object)postHandler, (String)"POST Handler must not be null.");
            this.router.post(resource.uri(), new Middleware[]{new PostRequestHandlerDelegator(postHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
            supported.add(HttpMethod.POST);
        } else {
            unsupported.add(HttpMethod.POST);
        }
        if (resource instanceof OptionsResource) {
            OptionsResource options = (OptionsResource)OptionsResource.class.cast(resource);
            OptionsRequestHandler optionsHandler = options.options();
            Assert.notNull((Object)optionsHandler, (String)"OPTIONS Handler must not be null.");
            this.router.options(resource.uri(), new Middleware[]{new OptionsRequestHandlerDelegator(optionsHandler, (Deserializer)this.deserializer, (Serializer)this.serializer, this.entityFactory, this.mediaTypeStrategy, this.hashStrategy, this.logger)});
            supported.add(HttpMethod.OPTIONS);
        } else {
            this.router.options(resource.uri(), (Handler)new OptionsHandler(supported));
            supported.add(HttpMethod.OPTIONS);
        }
        if (this.traceSupported) {
            this.router.trace(resource.uri(), (Handler)new TraceHandler());
            supported.add(HttpMethod.TRACE);
        }
        if (unsupported.contains((Object)HttpMethod.PATCH)) {
            this.router.patch(resource.uri(), (Handler)new MethodNotAllowedHandler(supported));
        }
        if (unsupported.contains((Object)HttpMethod.PUT)) {
            this.router.put(resource.uri(), (Handler)new MethodNotAllowedHandler(supported));
        }
        if (unsupported.contains((Object)HttpMethod.POST)) {
            this.router.post(resource.uri(), (Handler)new MethodNotAllowedHandler(supported));
        }
        if (unsupported.contains((Object)HttpMethod.DELETE)) {
            this.router.delete(resource.uri(), (Handler)new MethodNotAllowedHandler(supported));
        }
        return this;
    }
}

