/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.conneg;

import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.Q;
import org.apache.commons.lang3.StringUtils;

public class AcceptableMediaType
implements Q,
Comparable<AcceptableMediaType> {
    private final Double q;
    private final MediaType mediaType;

    public AcceptableMediaType(Double q, MediaType mediaType) {
        this.q = q;
        this.mediaType = mediaType;
    }

    @Override
    public Double q() {
        return this.q;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public int compareTo(AcceptableMediaType o) {
        int compareQ = o.q().compareTo(this.q());
        if (compareQ != 0) {
            return compareQ;
        }
        return this.mediaType.toString().compareTo(o.mediaType.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcceptableMediaType other = (AcceptableMediaType)obj;
        if (this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType)) {
            return false;
        }
        return !(this.q == null ? other.q != null : !this.q.equals(other.q));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mediaType).append(";").append("q=").append(this.q);
        return builder.toString();
    }

    public static AcceptableMediaType parse(String accept) {
        String[] parts = StringUtils.split((String)StringUtils.deleteWhitespace((String)accept), (char)';');
        MediaType mediaType = null;
        Double q = 1.0;
        if (parts != null) {
            if (parts.length >= 1) {
                mediaType = MediaType.parse(parts[0]);
            }
            if (parts.length >= 2) {
                q = Double.parseDouble(parts[1].substring(2).trim());
            }
        }
        return new AcceptableMediaType(q, mediaType);
    }
}

