/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.conneg;

import java.util.Locale;
import net.eusashead.parquet.http.conneg.Q;
import org.apache.commons.lang3.StringUtils;

public class AcceptableLanguage
implements Q,
Comparable<AcceptableLanguage> {
    private final Double q;
    private final Locale language;

    public AcceptableLanguage(Double q, Locale language) {
        this.q = q;
        this.language = language;
    }

    @Override
    public Double q() {
        return this.q;
    }

    public Locale language() {
        return this.language;
    }

    @Override
    public int compareTo(AcceptableLanguage o) {
        int compareQ = o.q().compareTo(this.q());
        if (compareQ != 0) {
            return compareQ;
        }
        return this.language.toString().compareTo(o.language.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcceptableLanguage other = (AcceptableLanguage)obj;
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.q == null ? other.q != null : !this.q.equals(other.q));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.language).append(";").append("q=").append(this.q);
        return builder.toString();
    }

    public static AcceptableLanguage parse(String accept) {
        String[] parts = StringUtils.split((String)StringUtils.deleteWhitespace((String)accept), (char)';');
        Locale locale = null;
        Double q = 1.0;
        if (parts != null) {
            if (parts.length >= 1) {
                locale = Locale.forLanguageTag(parts[0]);
            }
            if (parts.length >= 2) {
                q = Double.parseDouble(parts[1].substring(2).trim());
            }
        }
        return new AcceptableLanguage(q, locale);
    }
}

