/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http.conneg;

import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.conneg.Q;
import org.apache.commons.lang3.StringUtils;

public class AcceptableCharset
implements Q,
Comparable<AcceptableCharset> {
    private final Double q;
    private final Charset charset;

    public AcceptableCharset(Double q, Charset charset) {
        this.q = q;
        this.charset = charset;
    }

    @Override
    public Double q() {
        return this.q;
    }

    public Charset charset() {
        return this.charset;
    }

    @Override
    public int compareTo(AcceptableCharset o) {
        int compareQ = o.q().compareTo(this.q());
        if (compareQ != 0) {
            return compareQ;
        }
        return this.charset.compareTo(o.charset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcceptableCharset other = (AcceptableCharset)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        return !(this.q == null ? other.q != null : !this.q.equals(other.q));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.charset).append(";").append("q=").append(this.q);
        return builder.toString();
    }

    public static AcceptableCharset parse(String accept) {
        String[] parts = StringUtils.split((String)StringUtils.deleteWhitespace((String)accept), (char)';');
        Charset charset = null;
        Double q = 1.0;
        if (parts != null) {
            if (parts.length >= 1) {
                charset = new Charset(parts[0]);
            }
            if (parts.length >= 2) {
                q = Double.parseDouble(parts[1].substring(2).trim());
            }
        }
        return new AcceptableCharset(q, charset);
    }
}

