/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http;

import net.eusashead.parquet.http.Compatible;
import net.eusashead.parquet.util.Assert;
import org.apache.commons.lang3.StringUtils;

public class MediaType
implements Compatible<MediaType> {
    private static final String APPLICATION = "application";
    private static final String WILDCARD = "*";
    public static final MediaType ANY = new MediaType("*", "*");
    public static final MediaType APPLICATION_ANY = new MediaType("application", "*");
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_HAL_JSON = new MediaType("application", "hal+json");
    public static final MediaType APPLICATION_HAL_XML = new MediaType("application", "hal+xml");
    private final String type;
    private final String subType;

    public MediaType(String type, String subType) {
        Assert.notNull((Object)type);
        Assert.notNull((Object)subType);
        this.type = type;
        this.subType = subType;
    }

    public MediaType(String type) {
        Assert.notNull((Object)type);
        this.type = type;
        this.subType = WILDCARD;
    }

    public String type() {
        return this.type;
    }

    public String subType() {
        return this.subType;
    }

    @Override
    public boolean compatible(MediaType other) {
        return !(!this.type.equals(other.type) && !this.type.equals(WILDCARD) || !this.subType.equals(other.subType) && !this.subType.equals(WILDCARD));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaType other = (MediaType)obj;
        if (this.subType == null ? other.subType != null : !this.subType.equals(other.subType)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return this.type + "/" + this.subType;
    }

    public static MediaType parse(String mediaType) {
        String[] types = StringUtils.split((String)mediaType, (String)"/");
        if (types.length > 1) {
            String type = types[0].trim();
            String subType = types[1].trim();
            return new MediaType(type, subType);
        }
        throw new IllegalArgumentException(String.format("Cannot parse media type %s", mediaType));
    }
}

