/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.eusashead.parquet.http.HttpMethod;
import org.apache.commons.lang3.StringUtils;

public class HttpMethods
implements Iterable<HttpMethod> {
    private Set<HttpMethod> methods = new TreeSet<HttpMethod>();

    public HttpMethods(Collection<HttpMethod> methods) {
        this.methods.addAll(methods);
    }

    @Override
    public Iterator<HttpMethod> iterator() {
        return this.methods.iterator();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        for (HttpMethod meth : this.methods) {
            bldr.append(meth.name());
            bldr.append(",");
        }
        return bldr.substring(0, bldr.length() - 1);
    }

    public static HttpMethods parse(String allowHeader) {
        ArrayList<HttpMethod> allow = new ArrayList<HttpMethod>();
        for (String verb : StringUtils.split((String)allowHeader, (String)",")) {
            allow.add(HttpMethod.valueOf(verb));
        }
        return new HttpMethods(allow);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpMethods other = (HttpMethods)obj;
        return !(this.methods == null ? other.methods != null : !this.methods.equals(other.methods));
    }
}

