/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class HttpDate
implements Comparable<HttpDate> {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private final Date date;

    public HttpDate(long time) {
        long offset = time >= 0L ? 500L : -500L;
        long roundedNumber = (time + offset) / 1000L * 1000L;
        this.date = new Date(roundedNumber);
    }

    public Date date() {
        return new Date(this.date.getTime());
    }

    public String toString() {
        return HttpDate.getGmtDateFormatter().format(this.date);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpDate other = (HttpDate)obj;
        return !(this.date == null ? other.date != null : !this.date.equals(other.date));
    }

    public static HttpDate parse(String parse) throws ParseException {
        return new HttpDate(HttpDate.getGmtDateFormatter().parse(parse).getTime());
    }

    private static SimpleDateFormat getGmtDateFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat(HTTP_DATE_FORMAT);
        TimeZone GMT = TimeZone.getTimeZone("GMT");
        formatter.setTimeZone(GMT);
        return formatter;
    }

    @Override
    public int compareTo(HttpDate o) {
        return this.date.compareTo(o.date);
    }

    public boolean after(HttpDate date) {
        return this.compareTo(date) == 1;
    }

    public boolean before(HttpDate date) {
        return this.compareTo(date) == -1;
    }
}

