/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http;

import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.Compatible;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.util.Assert;
import org.apache.commons.lang3.StringUtils;

public class ContentType
implements Compatible<ContentType> {
    public static final ContentType APPLICATION_JSON_UTF8 = new ContentType(MediaType.APPLICATION_JSON, Charset.UTF8);
    public static final ContentType APPLICATION_XML_UTF8 = new ContentType(MediaType.APPLICATION_XML, Charset.UTF8);
    public static final ContentType HAL_JSON_UTF8 = new ContentType(MediaType.APPLICATION_HAL_JSON, Charset.UTF8);
    public static final ContentType HAL_XML_UTF8 = new ContentType(MediaType.APPLICATION_HAL_XML, Charset.UTF8);
    public static final ContentType APPLICATION_ANY_UTF8 = new ContentType(MediaType.APPLICATION_ANY, Charset.UTF8);
    public static final ContentType ANY_UTF8 = new ContentType(MediaType.ANY, Charset.UTF8);
    public static final ContentType ANY_ANY = new ContentType(MediaType.ANY, Charset.ANY);
    private final MediaType mediaType;
    private final Charset encoding;

    public ContentType(MediaType mediaType, Charset encoding) {
        Assert.notNull((Object)mediaType);
        Assert.notNull((Object)encoding);
        this.mediaType = mediaType;
        this.encoding = encoding;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public Charset charset() {
        return this.encoding;
    }

    @Override
    public boolean compatible(ContentType other) {
        return this.mediaType.compatible(other.mediaType) && this.encoding.compatible(other.encoding);
    }

    public static ContentType parse(String contentType) {
        String[] parts = StringUtils.split((String)StringUtils.deleteWhitespace((String)contentType), (char)';');
        String media = parts[0].trim();
        MediaType mediaType = MediaType.parse(media);
        Charset charset = parts.length == 2 ? Charset.fromContentType(contentType) : Charset.ANY;
        return new ContentType(mediaType, charset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        return !(this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType));
    }

    public String toString() {
        return this.mediaType.toString() + "; charset=" + this.encoding.name();
    }
}

