/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.parquet.http;

import net.eusashead.parquet.http.Compatible;
import org.apache.commons.lang3.StringUtils;

public class Charset
implements Comparable<Charset>,
Compatible<Charset> {
    private static final String WILDCARD = "*";
    public static final Charset ANY = new Charset("*");
    public static final Charset UTF8 = new Charset("utf-8");
    private final String name;

    public Charset(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public boolean compatible(Charset other) {
        return this.name.equals(other.name) || this.name.equals(WILDCARD);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Charset other = (Charset)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }

    public static Charset fromContentType(String contentTypeHeader) {
        int pos;
        String[] parts = StringUtils.split((String)StringUtils.deleteWhitespace((String)contentTypeHeader), (char)';');
        if (parts.length > 1 && parts[1] != null && (pos = parts[1].lastIndexOf("charset")) == 0) {
            String charsetName = parts[1].substring("charset=".length());
            return new Charset(charsetName);
        }
        throw new IllegalArgumentException(String.format("Cannot parse Content-Type header %s for charset", contentTypeHeader));
    }

    @Override
    public int compareTo(Charset o) {
        return this.name.compareTo(o.name);
    }
}

