package net.eusashead.parquet.http.serializer.hal;

import java.util.Map.Entry;

import net.eusashead.parquet.entity.EntityBuilder;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.entity.UriBuilder;

import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;

public class RepresentationEntityConverter implements EntityConverter<ReadableRepresentation> {

	@Override
	public EntityBuilder convert(ReadableRepresentation source, EntityFactory factory) {

		// Create EntityBuilder
		EntityBuilder entityBuilder = factory.newEntity();

		// Copy links
		for (Link link : source.getLinks()) {
			entityBuilder.link(new net.eusashead.parquet.entity.Link(link.getRel(), new UriBuilder(link.getHref()).build()));
		}

		// Copy properties
		for (String name : source.getProperties().keySet()) {
			entityBuilder.property(name, source.getValue(name));
		}

		// Copy relations
		for (Entry<String, ReadableRepresentation> rel : source.getResources()) {
			EntityBuilder related = this.convert(rel.getValue(), factory);
			entityBuilder.embed(rel.getKey(), related.build());
		}

		// Return Entity
		return entityBuilder;
	}

}
