package net.eusashead.parquet.http.serializer.hal;

import java.util.Arrays;
import java.util.Set;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.Charset;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.MediaType;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.AbstractSerializer;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;

import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;

public class HalSerializer extends AbstractSerializer implements Serializer {

	private static final MediaType[] mediaTypes = {
		MediaType.APPLICATION_HAL_JSON,
		MediaType.APPLICATION_HAL_XML};

	protected static final Charset[] charsets = {Charset.UTF8};

	private final RepresentationFactory representationFactory;

	/**
	 * Construct with default {@link StandardRepresentationFactory}
	 */
	public HalSerializer() {
		super(Arrays.asList(mediaTypes), Arrays.asList(charsets));
		this.representationFactory = new StandardRepresentationFactory();
	}
	
	/**
	 * Construct with supplied {@link RepresentationFactory}
	 * @param representationFactory {@link RepresentationFactory} to use
	 */
	public HalSerializer(RepresentationFactory representationFactory) {
		super(Arrays.asList(mediaTypes), Arrays.asList(charsets));
		this.representationFactory = representationFactory;
	}

	@Override
	public Body serialize(Entity target, Set<AcceptableContentType> accept) throws ResponseException {


		// Resolve content type
		Option<ContentType> contentType = resolveContentType(accept);

		// Make sure params are valid
		validate(target, contentType);
		
		// Perform serialization
		try {
			EntityRepresentationConverter converter = new EntityRepresentationConverter(representationFactory);
			Representation representation = converter.convert(target);
			return new Body(representation.toString(contentType.get().mediaType().toString()), contentType.get());
		} catch (IllegalArgumentException e) {
			throw new ResponseException(e);
		}
	}

}