package net.eusashead.parquet.http.serializer.hal;

import java.util.Collection;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.Link;

import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;

public class EntityRepresentationConverter implements
		RepresentationConverter<Entity> {
	
	private final RepresentationFactory representationFactory;
	
	public EntityRepresentationConverter(RepresentationFactory representationFactory) {
		this.representationFactory = representationFactory;
	}

	@Override
	public Representation convert(Entity source) {
		
		// Create Representation
		Representation representation = representationFactory.newRepresentation();
		
		// Copy links
		for (Link link : source.getLinks().values()) {
			representation.withLink(link.rel(), link.href());
		}
		
		// Copy properties
		for (String name : source.getProperties().keySet()) {
			representation.withProperty(name, source.getProperty(name));
		}
		
		// Copy relations
		for (String rel : source.getRelations().keySet()) {
			Collection<Entity> rels = source.getRelation(rel);
			for (Entity entity : rels) {
				Representation related = this.convert(entity);
				representation.withRepresentation(rel, related);
			}
		}

		// Return representation
		return representation;
	}

}
