package net.eusashead.parquet.http.serializer.composite;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.http.conneg.AcceptableContentType;
import net.eusashead.parquet.http.response.ResponseException;
import net.eusashead.parquet.http.serializer.AbstractSerializer;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;
import net.eusashead.parquet.util.Option;

public class CompositeSerializer extends AbstractSerializer implements Serializer {

	private final Map<ContentType, Serializer> components = new ConcurrentHashMap<>();

	/**
	 * Register a component {@link Serializer}
	 * that this {@link Serializer} will
	 * delegate serialization to
	 * @param component
	 * @return
	 */
	public CompositeSerializer register(Serializer component) {
		for (ContentType supported : component.contentTypes()) {
			this.supported.add(supported);
			this.components.put(supported, component);
		}
		return this;
	}

	@Override
	public Body serialize(Entity target, Set<AcceptableContentType> accept)
			throws ResponseException {

		// Resolve content type
		Option<ContentType> contentType = resolveContentType(accept);

		// Make sure params are valid
		validate(target, contentType);

		Serializer serializer = components.get(contentType.get());
		return serializer.serialize(target, accept);
	}

}
