package net.eusashead.parquet.http.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.eusashead.parquet.http.ContentType;
import net.eusashead.parquet.util.Assert;

import org.vertx.java.core.buffer.Buffer;

public abstract class AbstractDeserializer implements Deserializer {
	
	protected final List<ContentType> supported;

	public AbstractDeserializer() {
		this.supported = new ArrayList<>();
	}
	
	public AbstractDeserializer(List<ContentType> supported) {
		this.supported = supported;
	}

	@Override
	public boolean supports(ContentType contentType) {
		return supported.contains(contentType);
	}
	
	@Override
	public List<ContentType> contentTypes() {
		return Collections.unmodifiableList(supported);
	}

	protected void validate(Buffer body, ContentType contentType)
			throws DeserializationException {
		try {
			Assert.notNull(body);
			Assert.notNull(contentType);
			Assert.isTrue(supports(contentType), String.format("Deserializer %s does not support content type %s", this.getClass(), contentType));
		} catch (RuntimeException e) {
			throw new DeserializationException(e); 
		}
	}

}