package net.eusashead.parquet.http.response.impl;

import net.eusashead.parquet.entity.EntityFactory;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.request.Request;
import net.eusashead.parquet.http.response.Response;
import net.eusashead.parquet.http.serializer.Body;
import net.eusashead.parquet.http.serializer.Serializer;

import org.vertx.java.core.logging.Logger;

public class ErrorResponseBuilderImpl extends ResponseBuilderImpl {

	public ErrorResponseBuilderImpl(Request request, Response response,
			EntityFactory entityFactory, Serializer serializer,
			HashStrategy hashStrategy, Logger logger) {
		super(request, response, entityFactory, serializer,
				hashStrategy, logger);
		
	}

	@Override
	public void send() {

		if (!response.isCommitted()) {
			
			// Clear headers
			response.headers().clear();
			
			// Send body if not null
			if (!entityBuilder.empty()) {
				Body body = serialize();
				response
				.end(body.buffer());
			} else {
				response.end();
			}
		}

	};


}
