package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.etag.ETag;

public interface PutResponseBuilder extends ETagResponseBuilder {
	
	@Override
	PutResponseBuilder eTag(ETag version);
	
	@Override
	PutResponseBuilder eTag();
	
	@Override
	PutResponseBuilder lastModified(HttpDate lastModified);
	
	@Override
	PutResponseBuilder status(HttpStatus status);

	@Override
	PutResponseBuilder property(String name, Object value);
	
	@Override
	PutResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	PutResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> PutResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> PutResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	PutResponseBuilder link(Link link);
	
	@Override
	PutResponseBuilder body(Entity entity);
	
}
