package net.eusashead.parquet.http.response;

import java.net.URI;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.etag.ETag;


public interface PostResponseBuilder extends ETagResponseBuilder {

	/** 
	 * Add the supplied methods
	 * to the Allow header
	 * 
	 * @param methods
	 */
	PostResponseBuilder location(URI uri);
	
	@Override
	PostResponseBuilder eTag(ETag version);
	
	@Override
	PostResponseBuilder eTag();
	
	@Override
	PostResponseBuilder lastModified(HttpDate lastModified);
	
	@Override
	PostResponseBuilder status(HttpStatus status);
	
	@Override
	PostResponseBuilder property(String name, Object value);
	
	@Override
	PostResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	PostResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> PostResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> PostResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	PostResponseBuilder link(Link link);
	
	@Override
	PostResponseBuilder body(Entity entity);
	
}
