package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.etag.ETag;

public interface PatchResponseBuilder extends ETagResponseBuilder {
	
	@Override
	PatchResponseBuilder eTag(ETag version);
	
	@Override
	PatchResponseBuilder eTag();
	
	@Override
	PatchResponseBuilder lastModified(HttpDate lastModified);
	
	@Override
	PatchResponseBuilder status(HttpStatus status);

	@Override
	PatchResponseBuilder property(String name, Object value);
	
	@Override
	PatchResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	PatchResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> PatchResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> PatchResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	PatchResponseBuilder link(Link link);
	
	@Override
	PatchResponseBuilder body(Entity entity);
	
}
