package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpMethod;
import net.eusashead.parquet.http.HttpStatus;

public interface OptionsResponseBuilder extends ResponseBuilder {
	
	/** 
	 * Add the supplied methods
	 * to the Allow header
	 * 
	 * @param methods
	 */
	OptionsResponseBuilder allow(HttpMethod... methods);
	
	@Override
	OptionsResponseBuilder status(HttpStatus status);
	
	@Override
	OptionsResponseBuilder property(String name, Object value);
	
	@Override
	OptionsResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	OptionsResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> OptionsResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> OptionsResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	OptionsResponseBuilder link(Link link);
	
	@Override
	OptionsResponseBuilder body(Entity entity);

}
