package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.HttpStatus;
import net.eusashead.parquet.http.etag.ETag;

public interface GetResponseBuilder extends ETagResponseBuilder {
	
	@Override
	GetResponseBuilder eTag(ETag version);
	
	@Override
	GetResponseBuilder eTag();
	
	@Override
	GetResponseBuilder lastModified(HttpDate lastModified);
	
	/**
	 * Set the expiry time in milliseconds 
	 * that this resource should be cached for
	 * Sets Date, CacheControl and Expires headers
	 * @param millis {@link Long} expiry time in milliseconds
	 * @return this {@link GetResponseBuilder}
	 */
	GetResponseBuilder expires(Long millis);
	
	@Override
	GetResponseBuilder status(HttpStatus status);
	
	@Override
	GetResponseBuilder property(String name, Object value);
	
	@Override
	GetResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	GetResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> GetResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> GetResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	GetResponseBuilder link(Link link);
	
	@Override
	GetResponseBuilder body(Entity entity);

	@Override
	<T> GetResponseBuilder body(T target, EntityConverter<T> converter);

}
