package net.eusashead.parquet.http.response;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.entity.EntityConverter;
import net.eusashead.parquet.entity.Link;
import net.eusashead.parquet.entity.PropertyConverter;
import net.eusashead.parquet.http.HttpStatus;

public interface ErrorResponseBuilder extends ResponseBuilder {
	
	@Override
	ErrorResponseBuilder property(String name, Object value);
	
	@Override
	ErrorResponseBuilder property(String name, Object value, PropertyConverter<?,Object> converter);
	
	@Override
	ErrorResponseBuilder embed(String rel, Entity entity);
	
	@Override
	<T> ErrorResponseBuilder embed(String rel, T target, EntityConverter<T> converter);
	
	@Override
	<T> ErrorResponseBuilder forEach(String rel, Iterable<T> target, EntityConverter<T> converter);
	
	@Override
	ErrorResponseBuilder link(Link link);
	
	@Override
	ErrorResponseBuilder body(Entity entity);
	
	@Override
	<T> ErrorResponseBuilder body(T target, EntityConverter<T> converter);
	
	@Override
	ErrorResponseBuilder status(HttpStatus status);
	
	ErrorResponseBuilder message(String message);
	
}
