package net.eusashead.parquet.http.response;

import java.util.Date;

import net.eusashead.parquet.entity.Entity;
import net.eusashead.parquet.hash.HashStrategy;
import net.eusashead.parquet.http.HttpDate;
import net.eusashead.parquet.http.etag.ETag;

public interface ETagResponseBuilder extends ResponseBuilder {


	/**
	 * Set the ETag header  
	 * @param version {@link ETag} 
	 * @return this {@link ETagResponseBuilder}
	 */
	ETagResponseBuilder eTag(ETag version);

	/**
	 * Set a weak validating
	 * ETag using a hash of the 
	 * embedded entity. The hash
	 * is created using the {@link HashStrategy}
	 * specified for this {@link ResponseBuilder}
	 * on the string returned from the {@link Entity}
	 * toString() method.
	 * Note: If the {@link Entity} state is 
	 * modified after the {@link ETag} is created 
	 * it will not be valid
	 * @return this {@link ETagResponseBuilder}
	 */
	ETagResponseBuilder eTag();

	/**
	 * Set the Last-Modified header
	 * to the specified {@link Date}
	 * @param lastModified {@link Date} this entity last changed
	 * @return this {@link ETagResponseBuilder}
	 */
	ETagResponseBuilder lastModified(HttpDate lastModified);

}